/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.web.connect;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.social.connect.ServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServiceProviderLocator {
    private final Map<String, ServiceProvider<?>> serviceProviders;

    public ServiceProviderLocator(ListableBeanFactory beanFactory) {
        Map providers = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, ServiceProvider.class);
        this.serviceProviders = new HashMap(providers.size(), 1.0f);
        for (ServiceProvider provider : providers.values()) {
            this.serviceProviders.put(provider.getId(), provider);
        }
    }

    public ServiceProvider<?> getServiceProvider(String id) {
        return this.serviceProviders.get(id);
    }
}

