/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.web;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.support.OAuth1ConnectionFactory;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.social.oauth1.AuthorizedRequestToken;
import org.springframework.social.oauth1.OAuth1Operations;
import org.springframework.social.oauth1.OAuth1Parameters;
import org.springframework.social.oauth1.OAuth1Version;
import org.springframework.social.oauth1.OAuthToken;
import org.springframework.social.oauth2.AccessGrant;
import org.springframework.social.oauth2.GrantType;
import org.springframework.social.oauth2.OAuth2Operations;
import org.springframework.social.oauth2.OAuth2Parameters;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectSupport {
    private static final Log logger = LogFactory.getLog(ConnectSupport.class);
    private boolean useAuthenticateUrl;
    private String applicationUrl;
    private String callbackUrl;
    private static final String OAUTH_TOKEN_ATTRIBUTE = "oauthToken";

    public void setUseAuthenticateUrl(boolean useAuthenticateUrl) {
        this.useAuthenticateUrl = useAuthenticateUrl;
    }

    public void setApplicationUrl(String applicationUrl) {
        this.applicationUrl = applicationUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String buildOAuthUrl(ConnectionFactory<?> connectionFactory, NativeWebRequest request) {
        return this.buildOAuthUrl(connectionFactory, request, null);
    }

    public String buildOAuthUrl(ConnectionFactory<?> connectionFactory, NativeWebRequest request, MultiValueMap<String, String> additionalParameters) {
        if (connectionFactory instanceof OAuth1ConnectionFactory) {
            return this.buildOAuth1Url((OAuth1ConnectionFactory)connectionFactory, request, additionalParameters);
        }
        if (connectionFactory instanceof OAuth2ConnectionFactory) {
            return this.buildOAuth2Url((OAuth2ConnectionFactory)connectionFactory, request, additionalParameters);
        }
        throw new IllegalArgumentException("ConnectionFactory not supported");
    }

    public Connection<?> completeConnection(OAuth1ConnectionFactory<?> connectionFactory, NativeWebRequest request) {
        String verifier = request.getParameter("oauth_verifier");
        AuthorizedRequestToken requestToken = new AuthorizedRequestToken(this.extractCachedRequestToken((WebRequest)request), verifier);
        OAuthToken accessToken = connectionFactory.getOAuthOperations().exchangeForAccessToken(requestToken, null);
        return connectionFactory.createConnection(accessToken);
    }

    public Connection<?> completeConnection(OAuth2ConnectionFactory<?> connectionFactory, NativeWebRequest request) {
        String code = request.getParameter("code");
        try {
            AccessGrant accessGrant = connectionFactory.getOAuthOperations().exchangeForAccess(code, this.callbackUrl(request), null);
            return connectionFactory.createConnection(accessGrant);
        }
        catch (HttpClientErrorException e) {
            logger.warn((Object)("HttpClientErrorException while completing connection: " + e.getMessage()));
            logger.warn((Object)("      Response body: " + e.getResponseBodyAsString()));
            throw e;
        }
    }

    protected String callbackUrl(NativeWebRequest request) {
        if (this.callbackUrl != null) {
            return this.callbackUrl;
        }
        HttpServletRequest nativeRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
        if (this.applicationUrl != null) {
            return this.applicationUrl + this.connectPath(nativeRequest);
        }
        return nativeRequest.getRequestURL().toString();
    }

    private String buildOAuth1Url(OAuth1ConnectionFactory<?> connectionFactory, NativeWebRequest request, MultiValueMap<String, String> additionalParameters) {
        OAuth1Operations oauthOperations = connectionFactory.getOAuthOperations();
        MultiValueMap<String, String> requestParameters = this.getRequestParameters(request, new String[0]);
        OAuth1Parameters parameters = this.getOAuth1Parameters(request, additionalParameters);
        parameters.putAll(requestParameters);
        if (oauthOperations.getVersion() == OAuth1Version.CORE_10) {
            parameters.setCallbackUrl(this.callbackUrl(request));
        }
        OAuthToken requestToken = this.fetchRequestToken(request, requestParameters, oauthOperations);
        request.setAttribute(OAUTH_TOKEN_ATTRIBUTE, (Object)requestToken, 1);
        return this.buildOAuth1Url(oauthOperations, requestToken.getValue(), parameters);
    }

    private OAuth1Parameters getOAuth1Parameters(NativeWebRequest request, MultiValueMap<String, String> additionalParameters) {
        OAuth1Parameters parameters = new OAuth1Parameters(additionalParameters);
        parameters.putAll(this.getRequestParameters(request, new String[0]));
        return parameters;
    }

    private OAuthToken fetchRequestToken(NativeWebRequest request, MultiValueMap<String, String> requestParameters, OAuth1Operations oauthOperations) {
        if (oauthOperations.getVersion() == OAuth1Version.CORE_10_REVISION_A) {
            return oauthOperations.fetchRequestToken(this.callbackUrl(request), requestParameters);
        }
        return oauthOperations.fetchRequestToken(null, requestParameters);
    }

    private String buildOAuth2Url(OAuth2ConnectionFactory<?> connectionFactory, NativeWebRequest request, MultiValueMap<String, String> additionalParameters) {
        OAuth2Operations oauthOperations = connectionFactory.getOAuthOperations();
        String defaultScope = connectionFactory.getScope();
        OAuth2Parameters parameters = this.getOAuth2Parameters(request, defaultScope, additionalParameters);
        if (this.useAuthenticateUrl) {
            return oauthOperations.buildAuthenticateUrl(GrantType.AUTHORIZATION_CODE, parameters);
        }
        return oauthOperations.buildAuthorizeUrl(GrantType.AUTHORIZATION_CODE, parameters);
    }

    private OAuth2Parameters getOAuth2Parameters(NativeWebRequest request, String defaultScope, MultiValueMap<String, String> additionalParameters) {
        OAuth2Parameters parameters = new OAuth2Parameters(additionalParameters);
        parameters.putAll(this.getRequestParameters(request, "scope"));
        parameters.setRedirectUri(this.callbackUrl(request));
        String scope = request.getParameter("scope");
        if (scope != null) {
            parameters.setScope(scope);
        } else if (defaultScope != null) {
            parameters.setScope(defaultScope);
        }
        return parameters;
    }

    private String connectPath(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        return request.getServletPath() + (pathInfo != null ? pathInfo : "");
    }

    private String buildOAuth1Url(OAuth1Operations oauthOperations, String requestToken, OAuth1Parameters parameters) {
        if (this.useAuthenticateUrl) {
            return oauthOperations.buildAuthenticateUrl(requestToken, parameters);
        }
        return oauthOperations.buildAuthorizeUrl(requestToken, parameters);
    }

    private OAuthToken extractCachedRequestToken(WebRequest request) {
        OAuthToken requestToken = (OAuthToken)request.getAttribute(OAUTH_TOKEN_ATTRIBUTE, 1);
        request.removeAttribute(OAUTH_TOKEN_ATTRIBUTE, 1);
        return requestToken;
    }

    private MultiValueMap<String, String> getRequestParameters(NativeWebRequest request, String ... ignoredParameters) {
        List<String> ignoredParameterList = Arrays.asList(ignoredParameters);
        LinkedMultiValueMap convertedMap = new LinkedMultiValueMap();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            if (ignoredParameterList.contains(entry.getKey())) continue;
            convertedMap.put(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
        }
        return convertedMap;
    }
}

