/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.web;

import org.springframework.social.connect.Connection;
import org.springframework.social.connect.web.HttpSessionSessionStrategy;
import org.springframework.social.connect.web.ProviderSignInAttempt;
import org.springframework.social.connect.web.SessionStrategy;
import org.springframework.web.context.request.RequestAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderSignInUtils {
    private SessionStrategy sessionStrategy;

    public ProviderSignInUtils() {
        this(new HttpSessionSessionStrategy());
    }

    public ProviderSignInUtils(SessionStrategy sessionStrategy) {
        this.sessionStrategy = sessionStrategy;
    }

    public static Connection<?> getConnection(RequestAttributes request) {
        ProviderSignInAttempt signInAttempt = ProviderSignInUtils.getProviderUserSignInAttempt(request);
        return signInAttempt != null ? signInAttempt.getConnection() : null;
    }

    public Connection<?> getConnectionFromSession(RequestAttributes request) {
        ProviderSignInAttempt signInAttempt = ProviderSignInUtils.getProviderUserSignInAttempt(request);
        return signInAttempt != null ? signInAttempt.getConnection() : null;
    }

    public static void handlePostSignUp(String userId, RequestAttributes request) {
        ProviderSignInAttempt signInAttempt = ProviderSignInUtils.getProviderUserSignInAttempt(request);
        if (signInAttempt != null) {
            signInAttempt.addConnection(userId);
            request.removeAttribute(ProviderSignInAttempt.SESSION_ATTRIBUTE, 1);
        }
    }

    public void doPostSignUp(String userId, RequestAttributes request) {
        ProviderSignInAttempt signInAttempt = ProviderSignInUtils.getProviderUserSignInAttempt(request);
        if (signInAttempt != null) {
            signInAttempt.addConnection(userId);
            request.removeAttribute(ProviderSignInAttempt.SESSION_ATTRIBUTE, 1);
        }
    }

    private static ProviderSignInAttempt getProviderUserSignInAttempt(RequestAttributes request) {
        return (ProviderSignInAttempt)request.getAttribute(ProviderSignInAttempt.SESSION_ATTRIBUTE, 1);
    }
}

