/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.social.ApiException;
import org.springframework.social.InsufficientPermissionException;
import org.springframework.social.NotAuthorizedException;
import org.springframework.social.OperationNotPermittedException;
import org.springframework.social.UserIdSource;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.connect.web.ThrowableAnalyzer;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public class ReconnectFilter
extends GenericFilterBean {
    private static final Log logger = LogFactory.getLog(ReconnectFilter.class);
    private ThrowableAnalyzer throwableAnalyzer = new ThrowableAnalyzer();
    private UsersConnectionRepository usersConnectionRepository;
    private UserIdSource userIdSource;
    private static final String CONNECT_PATH = "/connect/";
    private static final int CONNECT_PATH_LENGTH = "/connect/".length() + 1;
    private static final String RECONNECT_PARAMETER = "reconnect";
    private static final String RECONNECT_PARAMETER_EQUALS_TRUE = "?reconnect=true";
    private static final String SCOPE_PARAMETER_EQUALS = "&scope=";
    private static final String POST = "POST";
    private static final String GET = "GET";

    public ReconnectFilter(UsersConnectionRepository usersConnectionRepository, UserIdSource userIdSource) {
        Assert.notNull((Object)usersConnectionRepository, (String)"UsersConnectionRepository cannot be null");
        Assert.notNull((Object)userIdSource, (String)"UserIdSource cannot be null");
        this.usersConnectionRepository = usersConnectionRepository;
        this.userIdSource = userIdSource;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.shouldPerformRefreshPostRequest(httpRequest)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Removing stale/revoked connection.");
            }
            String providerId = this.getProviderIdFromRequest(httpRequest);
            String currentUserId = this.userIdSource.getUserId();
            this.usersConnectionRepository.createConnectionRepository(currentUserId).removeConnections(providerId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Initiating refresh request.");
            }
            ReconnectionPostRequest newRequest = new ReconnectionPostRequest(httpRequest);
            chain.doFilter((ServletRequest)newRequest, (ServletResponse)httpResponse);
        } else {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Processing request");
                }
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
            catch (IOException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("IOException: " + e.getMessage()));
                }
                throw e;
            }
            catch (Exception e) {
                this.handleExceptionFromFilterChain(e, httpRequest, httpResponse);
            }
        }
    }

    protected String getRefreshUrl(HttpServletRequest request, ApiException apiException) {
        String scopeNeeded = this.getRequiredScope(apiException);
        StringBuilder sb = new StringBuilder(request.getContextPath() + CONNECT_PATH + apiException.getProviderId()).append(RECONNECT_PARAMETER_EQUALS_TRUE);
        if (scopeNeeded != null) {
            sb.append(SCOPE_PARAMETER_EQUALS + scopeNeeded);
        }
        return sb.toString();
    }

    protected boolean shouldPerformRefreshPostRequest(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        return request.getMethod().equalsIgnoreCase(GET) && servletPath != null && servletPath.startsWith(CONNECT_PATH) && request.getParameter(RECONNECT_PARAMETER) != null;
    }

    private String getRequiredScope(ApiException apiException) {
        return apiException instanceof InsufficientPermissionException ? ((InsufficientPermissionException)apiException).getRequiredPermission() : null;
    }

    private String getProviderIdFromRequest(HttpServletRequest httpRequest) {
        return httpRequest.getServletPath().substring(CONNECT_PATH_LENGTH);
    }

    private void handleExceptionFromFilterChain(Exception e, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        ApiException ase = (ApiException)this.throwableAnalyzer.getFirstThrowableOfType(ApiException.class, this.throwableAnalyzer.determineCauseChain(e));
        if (ase != null && ase instanceof ApiException) {
            ApiException apiException = ase;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("API Exception: " + e.getMessage()));
            }
            if (apiException instanceof NotAuthorizedException || apiException instanceof OperationNotPermittedException) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Redirecting for refresh of " + apiException.getProviderId() + " connection."));
                }
                httpResponse.sendRedirect(this.getRefreshUrl(httpRequest, apiException));
                return;
            }
        }
        if (e instanceof ServletException) {
            throw (ServletException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    private final class ReconnectionPostRequest
    extends HttpServletRequestWrapper {
        private ReconnectionPostRequest(HttpServletRequest request) {
            super(request);
        }

        public String getMethod() {
            return ReconnectFilter.POST;
        }
    }
}

