/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.annotation;

import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.AjTypeSystem;
import org.aspectj.lang.reflect.PerClauseKind;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.framework.AopConfigException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectMetadata {
    private final AjType ajType;
    private final Pointcut perClausePointcut;

    public AspectMetadata(Class<?> aspectClass) {
        this.ajType = AjTypeSystem.getAjType(aspectClass);
        if (!this.ajType.isAspect()) {
            throw new IllegalArgumentException(aspectClass + " is not an @AspectJ aspect");
        }
        this.validate();
        switch (this.ajType.getPerClause().getKind()) {
            case SINGLETON: {
                this.perClausePointcut = Pointcut.TRUE;
                return;
            }
            case PERTARGET: 
            case PERTHIS: {
                AspectJExpressionPointcut ajexp = new AspectJExpressionPointcut();
                ajexp.setLocation("@Aspect annotation on " + aspectClass.getName());
                ajexp.setExpression(this.findPerClause(aspectClass));
                this.perClausePointcut = ajexp;
                return;
            }
        }
        throw new AopConfigException("PerClause " + this.ajType.getPerClause().getKind() + " not supported by Spring AOP for class " + aspectClass.getName());
    }

    private void validate() throws IllegalArgumentException {
        if (this.ajType.getDeclarePrecedence().length > 0) {
            throw new IllegalArgumentException("DeclarePrecendence not presently supported in Spring AOP");
        }
    }

    public boolean isPerThisOrPerTarget() {
        PerClauseKind kind = this.getAjType().getPerClause().getKind();
        return kind == PerClauseKind.PERTARGET || kind == PerClauseKind.PERTHIS;
    }

    private String findPerClause(Class<?> aspectClass) {
        String s = aspectClass.getAnnotation(Aspect.class).value();
        s = s.substring(s.indexOf("(") + 1);
        s = s.substring(0, s.length() - 1);
        return s;
    }

    public AjType getAjType() {
        return this.ajType;
    }

    public Class<?> getAspectClass() {
        return this.ajType.getJavaClass();
    }

    public Pointcut getPerClausePointcut() {
        return this.perClausePointcut;
    }
}

