/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.Serializable;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.ClassFilters;
import org.springframework.aop.support.MethodMatchers;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ComposablePointcut
implements Pointcut,
Serializable {
    private static final long serialVersionUID = -2743223737633663832L;
    private ClassFilter classFilter;
    private MethodMatcher methodMatcher;

    public ComposablePointcut() {
        this.classFilter = ClassFilter.TRUE;
        this.methodMatcher = MethodMatcher.TRUE;
    }

    public ComposablePointcut(ClassFilter classFilter) {
        Assert.notNull((Object)classFilter, (String)"ClassFilter must not be null");
        this.classFilter = classFilter;
        this.methodMatcher = MethodMatcher.TRUE;
    }

    public ComposablePointcut(MethodMatcher methodMatcher) {
        Assert.notNull((Object)methodMatcher, (String)"MethodMatcher must not be null");
        this.classFilter = ClassFilter.TRUE;
        this.methodMatcher = methodMatcher;
    }

    public ComposablePointcut(ClassFilter classFilter, MethodMatcher methodMatcher) {
        Assert.notNull((Object)classFilter, (String)"ClassFilter must not be null");
        Assert.notNull((Object)methodMatcher, (String)"MethodMatcher must not be null");
        this.classFilter = classFilter;
        this.methodMatcher = methodMatcher;
    }

    public ComposablePointcut union(ClassFilter filter) {
        this.classFilter = ClassFilters.union(this.classFilter, filter);
        return this;
    }

    public ComposablePointcut intersection(ClassFilter filter) {
        this.classFilter = ClassFilters.intersection(this.classFilter, filter);
        return this;
    }

    public ComposablePointcut union(MethodMatcher mm) {
        this.methodMatcher = MethodMatchers.union(this.methodMatcher, mm);
        return this;
    }

    public ComposablePointcut intersection(MethodMatcher mm) {
        this.methodMatcher = MethodMatchers.intersection(this.methodMatcher, mm);
        return this;
    }

    public ComposablePointcut intersection(Pointcut other) {
        this.classFilter = ClassFilters.intersection(this.classFilter, other.getClassFilter());
        this.methodMatcher = MethodMatchers.intersection(this.methodMatcher, other.getMethodMatcher());
        return this;
    }

    public ClassFilter getClassFilter() {
        return this.classFilter;
    }

    public MethodMatcher getMethodMatcher() {
        return this.methodMatcher;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ComposablePointcut)) {
            return false;
        }
        ComposablePointcut that = (ComposablePointcut)other;
        return ObjectUtils.nullSafeEquals((Object)that.classFilter, (Object)this.classFilter) && ObjectUtils.nullSafeEquals((Object)that.methodMatcher, (Object)this.methodMatcher);
    }

    public int hashCode() {
        int code = 17;
        if (this.classFilter != null) {
            code = 37 * code + this.classFilter.hashCode();
        }
        if (this.methodMatcher != null) {
            code = 37 * code + this.methodMatcher.hashCode();
        }
        return code;
    }

    public String toString() {
        return "ComposablePointcut consisting of ClassFilter [" + this.classFilter + "] and MethodMatcher [" + this.methodMatcher + "]";
    }
}

