/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.config;

import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class AspectJAutoProxyBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String PROXY_TARGET_ATTRIBUTE = "proxy-target-class";
    private static final String PROXY_TARGET_CLASS = Conventions.attributeNameToPropertyName((String)"proxy-target-class");

    AspectJAutoProxyBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        AopNamespaceUtils.registerAtAspectJAutoProxyCreatorIfNecessary(parserContext, element);
        this.extendBeanDefinition(element, parserContext);
        return null;
    }

    private void extendBeanDefinition(Element element, ParserContext parserContext) {
        BeanDefinition beanDef = parserContext.getRegistry().getBeanDefinition("org.springframework.aop.config.internalAutoProxyCreator");
        String proxyTargetClass = element.getAttribute(PROXY_TARGET_ATTRIBUTE);
        if (StringUtils.hasText((String)proxyTargetClass)) {
            beanDef.getPropertyValues().addPropertyValue(PROXY_TARGET_CLASS, (Object)proxyTargetClass);
        }
        if (element.hasChildNodes()) {
            this.addIncludePatterns(element, parserContext, beanDef);
        }
    }

    private void addIncludePatterns(Element element, ParserContext parserContext, BeanDefinition beanDef) {
        ManagedList includePatterns = new ManagedList();
        includePatterns.setSource(parserContext.extractSource((Object)element));
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Element)) continue;
            Element includeElement = (Element)node;
            TypedStringValue valueHolder = new TypedStringValue(includeElement.getAttribute("name"));
            valueHolder.setSource(parserContext.extractSource((Object)includeElement));
            includePatterns.add((Object)valueHolder);
        }
        beanDef.getPropertyValues().addPropertyValue("includePatterns", (Object)includePatterns);
    }
}

