/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.Serializable;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractGenericPointcutAdvisor;
import org.springframework.aop.support.AbstractRegexpMethodPointcut;
import org.springframework.aop.support.JdkRegexpMethodPointcut;
import org.springframework.aop.support.Perl5RegexpMethodPointcut;
import org.springframework.core.JdkVersion;
import org.springframework.util.ObjectUtils;

public class RegexpMethodPointcutAdvisor
extends AbstractGenericPointcutAdvisor {
    private String[] patterns;
    private boolean perl5 = false;
    private AbstractRegexpMethodPointcut pointcut;
    private final Object pointcutMonitor = new SerializableMonitor();

    public RegexpMethodPointcutAdvisor() {
    }

    public RegexpMethodPointcutAdvisor(Advice advice) {
        this.setAdvice(advice);
    }

    public RegexpMethodPointcutAdvisor(String pattern, Advice advice) {
        this.setPattern(pattern);
        this.setAdvice(advice);
    }

    public RegexpMethodPointcutAdvisor(String[] patterns, Advice advice) {
        this.setPatterns(patterns);
        this.setAdvice(advice);
    }

    public void setPattern(String pattern) {
        this.setPatterns(new String[]{pattern});
    }

    public void setPatterns(String[] patterns) {
        this.patterns = patterns;
    }

    public void setPerl5(boolean perl5) {
        this.perl5 = perl5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pointcut getPointcut() {
        Object object = this.pointcutMonitor;
        synchronized (object) {
            if (this.pointcut == null) {
                this.pointcut = this.createPointcut();
                this.pointcut.setPatterns(this.patterns);
            }
            return this.pointcut;
        }
    }

    protected AbstractRegexpMethodPointcut createPointcut() {
        if (this.perl5 || JdkVersion.getMajorJavaVersion() < 1) {
            return Perl5RegexpPointcutFactory.createPerl5RegexpPointcut();
        }
        return new JdkRegexpMethodPointcut();
    }

    public String toString() {
        return this.getClass().getName() + ": advice [" + this.getAdvice() + "], pointcut patterns " + ObjectUtils.nullSafeToString((Object[])this.patterns);
    }

    private static class SerializableMonitor
    implements Serializable {
        private SerializableMonitor() {
        }
    }

    private static class Perl5RegexpPointcutFactory {
        private Perl5RegexpPointcutFactory() {
        }

        public static AbstractRegexpMethodPointcut createPerl5RegexpPointcut() {
            return new Perl5RegexpMethodPointcut();
        }
    }
}

