/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support.annotation;

import java.lang.annotation.Annotation;
import org.springframework.aop.ClassFilter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

public class AnnotationClassFilter
implements ClassFilter {
    private final Class<? extends Annotation> annotationType;
    private final boolean checkInherited;

    public AnnotationClassFilter(Class<? extends Annotation> annotationType) {
        this(annotationType, false);
    }

    public AnnotationClassFilter(Class<? extends Annotation> annotationType, boolean checkInherited) {
        Assert.notNull(annotationType, (String)"Annotation type must not be null");
        this.annotationType = annotationType;
        this.checkInherited = checkInherited;
    }

    public boolean matches(Class clazz) {
        return this.checkInherited ? AnnotationUtils.findAnnotation((Class)clazz, this.annotationType) != null : clazz.isAnnotationPresent(this.annotationType);
    }
}

