/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.AutowireUtils;
import org.springframework.beans.factory.support.BeanDefinitionValueResolver;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.MethodParameter;
import org.springframework.util.ReflectionUtils;

abstract class ConstructorResolver {
    private final AbstractBeanFactory beanFactory;
    private final InstantiationStrategy instantiationStrategy;

    public ConstructorResolver(AbstractBeanFactory beanFactory, InstantiationStrategy instantiationStrategy) {
        this.beanFactory = beanFactory;
        this.instantiationStrategy = instantiationStrategy;
    }

    protected BeanWrapper autowireConstructor(String beanName, RootBeanDefinition mergedBeanDefinition) throws BeansException {
        ConstructorArgumentValues cargs = mergedBeanDefinition.getConstructorArgumentValues();
        ConstructorArgumentValues resolvedValues = new ConstructorArgumentValues();
        BeanWrapperImpl bw = new BeanWrapperImpl();
        this.beanFactory.initBeanWrapper(bw);
        int minNrOfArgs = 0;
        if (cargs != null) {
            minNrOfArgs = this.resolveConstructorArguments(beanName, mergedBeanDefinition, bw, cargs, resolvedValues);
        }
        Constructor[] candidates = mergedBeanDefinition.getBeanClass().getDeclaredConstructors();
        AutowireUtils.sortConstructors(candidates);
        Constructor constructorToUse = null;
        Object[] argsToUse = null;
        int minTypeDiffWeight = Integer.MAX_VALUE;
        for (int i = 0; i < candidates.length; ++i) {
            Constructor constructor = candidates[i];
            if (constructorToUse != null && constructorToUse.getParameterTypes().length > constructor.getParameterTypes().length) break;
            if (constructor.getParameterTypes().length < minNrOfArgs) {
                throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, minNrOfArgs + " constructor arguments specified but no matching constructor found in bean '" + beanName + "' " + "(hint: specify index and/or type arguments for simple parameters to avoid type ambiguities)");
            }
            try {
                Class[] paramTypes = constructor.getParameterTypes();
                ArgumentsHolder args = this.createArgumentArray(beanName, mergedBeanDefinition, resolvedValues, bw, paramTypes, constructor);
                int typeDiffWeight = args.getTypeDifferenceWeight(paramTypes);
                if (typeDiffWeight >= minTypeDiffWeight) continue;
                constructorToUse = constructor;
                argsToUse = args.arguments;
                minTypeDiffWeight = typeDiffWeight;
                continue;
            }
            catch (UnsatisfiedDependencyException ex) {
                if (this.beanFactory.logger.isTraceEnabled()) {
                    this.beanFactory.logger.trace((Object)("Ignoring constructor [" + constructor + "] of bean '" + beanName + "': " + (Object)((Object)ex)));
                }
                if (i != candidates.length - 1 || constructorToUse != null) continue;
                throw ex;
            }
        }
        if (constructorToUse == null) {
            throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Could not resolve matching constructor");
        }
        Object beanInstance = this.instantiationStrategy.instantiate(mergedBeanDefinition, beanName, this.beanFactory, constructorToUse, argsToUse);
        bw.setWrappedInstance(beanInstance);
        if (this.beanFactory.logger.isDebugEnabled()) {
            this.beanFactory.logger.debug((Object)("Bean '" + beanName + "' instantiated via constructor [" + constructorToUse + "]"));
        }
        return bw;
    }

    public BeanWrapper instantiateUsingFactoryMethod(String beanName, RootBeanDefinition mergedBeanDefinition, Object[] explicitArgs) throws BeansException {
        Object beanInstance;
        BeanWrapperImpl bw = new BeanWrapperImpl();
        this.beanFactory.initBeanWrapper(bw);
        ConstructorArgumentValues cargs = mergedBeanDefinition.getConstructorArgumentValues();
        ConstructorArgumentValues resolvedValues = null;
        int minNrOfArgs = 0;
        if (explicitArgs == null) {
            resolvedValues = new ConstructorArgumentValues();
            minNrOfArgs = this.resolveConstructorArguments(beanName, mergedBeanDefinition, bw, cargs, resolvedValues);
        } else {
            minNrOfArgs = explicitArgs.length;
        }
        boolean isStatic = true;
        Class<?> factoryClass = null;
        Object factoryBean = null;
        if (mergedBeanDefinition.getFactoryBeanName() != null) {
            factoryBean = this.beanFactory.getBean(mergedBeanDefinition.getFactoryBeanName());
            factoryClass = factoryBean.getClass();
            isStatic = false;
        } else {
            factoryClass = mergedBeanDefinition.getBeanClass();
        }
        Method[] candidates = ReflectionUtils.getAllDeclaredMethods((Class)factoryClass);
        AccessibleObject factoryMethodToUse = null;
        Object[] argsToUse = null;
        int minTypeDiffWeight = Integer.MAX_VALUE;
        for (int i = 0; i < candidates.length; ++i) {
            Method factoryMethod = candidates[i];
            if (Modifier.isStatic(factoryMethod.getModifiers()) != isStatic || !factoryMethod.getName().equals(mergedBeanDefinition.getFactoryMethodName()) || factoryMethod.getParameterTypes().length < minNrOfArgs) continue;
            Class[] paramTypes = factoryMethod.getParameterTypes();
            ArgumentsHolder args = null;
            if (resolvedValues != null) {
                try {
                    args = this.createArgumentArray(beanName, mergedBeanDefinition, resolvedValues, bw, paramTypes, factoryMethod);
                }
                catch (UnsatisfiedDependencyException ex) {
                    if (this.beanFactory.logger.isTraceEnabled()) {
                        this.beanFactory.logger.trace((Object)("Ignoring factory method [" + factoryMethod + "] of bean '" + beanName + "': " + (Object)((Object)ex)));
                    }
                    if (i != candidates.length - 1 || factoryMethodToUse != null) continue;
                    throw ex;
                }
            } else {
                if (paramTypes.length != explicitArgs.length) continue;
                args = new ArgumentsHolder(explicitArgs);
            }
            int typeDiffWeight = args.getTypeDifferenceWeight(paramTypes);
            if (typeDiffWeight >= minTypeDiffWeight) continue;
            factoryMethodToUse = factoryMethod;
            argsToUse = args.arguments;
            minTypeDiffWeight = typeDiffWeight;
        }
        if (factoryMethodToUse == null) {
            throw new BeanDefinitionStoreException("No matching factory method found: " + (mergedBeanDefinition.getFactoryBeanName() != null ? "factory bean '" + mergedBeanDefinition.getFactoryBeanName() + "'; " : "") + "factory method '" + mergedBeanDefinition.getFactoryMethodName() + "'");
        }
        if (!factoryMethodToUse.isAccessible()) {
            ((Method)factoryMethodToUse).setAccessible(true);
        }
        if ((beanInstance = this.instantiationStrategy.instantiate(mergedBeanDefinition, beanName, this.beanFactory, factoryBean, (Method)factoryMethodToUse, argsToUse)) == null) {
            return null;
        }
        bw.setWrappedInstance(beanInstance);
        if (this.beanFactory.logger.isDebugEnabled()) {
            this.beanFactory.logger.debug((Object)("Bean '" + beanName + "' instantiated via factory method '" + factoryMethodToUse + "'"));
        }
        return bw;
    }

    private int resolveConstructorArguments(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, ConstructorArgumentValues cargs, ConstructorArgumentValues resolvedValues) {
        BeanDefinitionValueResolver valueResolver = new BeanDefinitionValueResolver(this.beanFactory, beanName, mergedBeanDefinition, bw);
        int minNrOfArgs = cargs.getArgumentCount();
        Iterator it = cargs.getIndexedArgumentValues().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            int index = (Integer)entry.getKey();
            if (index < 0) {
                throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Invalid constructor argument index: " + index);
            }
            if (index > minNrOfArgs) {
                minNrOfArgs = index + 1;
            }
            String argName = "constructor argument with index " + index;
            ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)entry.getValue();
            Object resolvedValue = valueResolver.resolveValueIfNecessary(argName, valueHolder.getValue());
            resolvedValues.addIndexedArgumentValue(index, resolvedValue, valueHolder.getType());
        }
        it = cargs.getGenericArgumentValues().iterator();
        while (it.hasNext()) {
            ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)((Object)it.next());
            String argName = "constructor argument";
            Object resolvedValue = valueResolver.resolveValueIfNecessary(argName, valueHolder.getValue());
            resolvedValues.addGenericArgumentValue(resolvedValue, valueHolder.getType());
        }
        return minNrOfArgs;
    }

    private ArgumentsHolder createArgumentArray(String beanName, RootBeanDefinition mergedBeanDefinition, ConstructorArgumentValues resolvedValues, BeanWrapper bw, Class[] paramTypes, Object methodOrCtor) throws UnsatisfiedDependencyException {
        String methodType = methodOrCtor instanceof Constructor ? "constructor" : "factory method";
        ArgumentsHolder args = new ArgumentsHolder(paramTypes.length);
        HashSet<ConstructorArgumentValues.ValueHolder> usedValueHolders = new HashSet<ConstructorArgumentValues.ValueHolder>(paramTypes.length);
        for (int index = 0; index < paramTypes.length; ++index) {
            ConstructorArgumentValues.ValueHolder valueHolder = resolvedValues.getArgumentValue(index, paramTypes[index], usedValueHolders);
            if (valueHolder == null && mergedBeanDefinition.getResolvedAutowireMode() != 3) {
                valueHolder = resolvedValues.getGenericArgumentValue(null, usedValueHolders);
            }
            if (valueHolder != null) {
                usedValueHolders.add(valueHolder);
                args.rawArguments[index] = valueHolder.getValue();
                try {
                    args.arguments[index] = this.beanFactory.doTypeConversionIfNecessary(bw, args.rawArguments[index], paramTypes[index], MethodParameter.forMethodOrConstructor((Object)methodOrCtor, (int)index));
                    continue;
                }
                catch (TypeMismatchException ex) {
                    throw new UnsatisfiedDependencyException(mergedBeanDefinition.getResourceDescription(), beanName, index, paramTypes[index], "Could not convert " + methodType + " argument value [" + valueHolder.getValue() + "] to required type [" + paramTypes[index].getName() + "]: " + ex.getMessage());
                }
            }
            if (mergedBeanDefinition.getResolvedAutowireMode() != 3) {
                throw new UnsatisfiedDependencyException(mergedBeanDefinition.getResourceDescription(), beanName, index, paramTypes[index], "Ambiguous " + methodType + " argument types - " + "did you specify the correct bean references as " + methodType + " arguments?");
            }
            Map matchingBeans = this.findAutowireCandidates(beanName, paramTypes[index]);
            if (matchingBeans.size() != 1) {
                throw new UnsatisfiedDependencyException(mergedBeanDefinition.getResourceDescription(), beanName, index, paramTypes[index], "There are " + matchingBeans.size() + " beans of type [" + paramTypes[index].getName() + "] available for autowiring: " + matchingBeans.keySet() + ". There should have been exactly 1 to be able to autowire " + methodType + " of bean '" + beanName + "'.");
            }
            Map.Entry entry = matchingBeans.entrySet().iterator().next();
            String autowiredBeanName = (String)entry.getKey();
            Object autowiredBean = entry.getValue();
            args.rawArguments[index] = autowiredBean;
            args.arguments[index] = autowiredBean;
            if (mergedBeanDefinition.isSingleton()) {
                this.beanFactory.registerDependentBean(autowiredBeanName, beanName);
            }
            if (!this.beanFactory.logger.isDebugEnabled()) continue;
            this.beanFactory.logger.debug((Object)("Autowiring by type from bean name '" + beanName + "' via " + methodType + " to bean named '" + autowiredBeanName + "'"));
        }
        return args;
    }

    protected abstract Map findAutowireCandidates(String var1, Class var2) throws BeansException;

    private static class ArgumentsHolder {
        public Object[] rawArguments;
        public Object[] arguments;

        public ArgumentsHolder(int size) {
            this.rawArguments = new Object[size];
            this.arguments = new Object[size];
        }

        public ArgumentsHolder(Object[] args) {
            this.rawArguments = args;
            this.arguments = args;
        }

        public int getTypeDifferenceWeight(Class[] paramTypes) {
            int typeDiffWeight = AutowireUtils.getTypeDifferenceWeight(paramTypes, this.arguments);
            int rawTypeDiffWeight = AutowireUtils.getTypeDifferenceWeight(paramTypes, this.rawArguments) - 1024;
            return rawTypeDiffWeight < typeDiffWeight ? rawTypeDiffWeight : typeDiffWeight;
        }
    }
}

