/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitDestroyAnnotationBeanPostProcessor
implements DestructionAwareBeanPostProcessor,
MergedBeanDefinitionPostProcessor,
PriorityOrdered,
Serializable {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Class<? extends Annotation> initAnnotationType;
    private Class<? extends Annotation> destroyAnnotationType;
    private int order = Integer.MAX_VALUE;
    private final transient Map<Class<?>, LifecycleMetadata> lifecycleMetadataCache = new ConcurrentHashMap();

    public void setInitAnnotationType(Class<? extends Annotation> initAnnotationType) {
        this.initAnnotationType = initAnnotationType;
    }

    public void setDestroyAnnotationType(Class<? extends Annotation> destroyAnnotationType) {
        this.destroyAnnotationType = destroyAnnotationType;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class beanType, String beanName) {
        if (beanType != null) {
            String methodName;
            LifecycleMetadata metadata = this.findLifecycleMetadata(beanType);
            Iterator<LifecycleElement> it = metadata.getInitMethods().iterator();
            while (it.hasNext()) {
                methodName = this.calculateMethodIdentifierInHierarchy(it.next().getMethod());
                if (!beanDefinition.isExternallyManagedInitMethod(methodName)) {
                    beanDefinition.registerExternallyManagedInitMethod(methodName);
                    continue;
                }
                it.remove();
            }
            it = metadata.getDestroyMethods().iterator();
            while (it.hasNext()) {
                methodName = this.calculateMethodIdentifierInHierarchy(it.next().getMethod());
                if (!beanDefinition.isExternallyManagedDestroyMethod(methodName)) {
                    beanDefinition.registerExternallyManagedDestroyMethod(methodName);
                    continue;
                }
                it.remove();
            }
        }
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        LifecycleMetadata metadata = this.findLifecycleMetadata(bean.getClass());
        try {
            metadata.invokeInitMethods(bean, beanName);
        }
        catch (InvocationTargetException ex) {
            throw new BeanCreationException(beanName, "Invocation of init method failed", ex.getTargetException());
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Couldn't invoke init method", ex);
        }
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        LifecycleMetadata metadata = this.findLifecycleMetadata(bean.getClass());
        try {
            metadata.invokeDestroyMethods(bean, beanName);
        }
        catch (InvocationTargetException ex) {
            String msg = "Invocation of destroy method failed on bean with name '" + beanName + "'";
            if (this.logger.isDebugEnabled()) {
                this.logger.warn((Object)msg, ex.getTargetException());
            } else {
                this.logger.warn((Object)(String.valueOf(msg) + ": " + ex.getTargetException()));
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)("Couldn't invoke destroy method on bean with name '" + beanName + "'"), ex);
        }
    }

    private String calculateMethodIdentifierInHierarchy(Method method) {
        if (Modifier.isPrivate(method.getModifiers())) {
            return method.getDeclaringClass() + "." + method.getName();
        }
        return method.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LifecycleMetadata findLifecycleMetadata(Class clazz) {
        if (this.lifecycleMetadataCache == null) {
            return this.buildLifecycleMetadata(clazz);
        }
        LifecycleMetadata metadata = this.lifecycleMetadataCache.get(clazz);
        if (metadata == null) {
            Map<Class<?>, LifecycleMetadata> map = this.lifecycleMetadataCache;
            synchronized (map) {
                metadata = this.lifecycleMetadataCache.get(clazz);
                if (metadata == null) {
                    metadata = this.buildLifecycleMetadata(clazz);
                    this.lifecycleMetadataCache.put(clazz, metadata);
                }
                return metadata;
            }
        }
        return metadata;
    }

    private LifecycleMetadata buildLifecycleMetadata(final Class clazz) {
        final LifecycleMetadata newMetadata = new LifecycleMetadata();
        final boolean debug = this.logger.isDebugEnabled();
        ReflectionUtils.doWithMethods((Class)clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                if (InitDestroyAnnotationBeanPostProcessor.this.initAnnotationType != null && method.getAnnotation(InitDestroyAnnotationBeanPostProcessor.this.initAnnotationType) != null) {
                    newMetadata.addInitMethod(method);
                    if (debug) {
                        InitDestroyAnnotationBeanPostProcessor.this.logger.debug((Object)("Found init method on class [" + clazz.getName() + "]: " + method));
                    }
                }
                if (InitDestroyAnnotationBeanPostProcessor.this.destroyAnnotationType != null && method.getAnnotation(InitDestroyAnnotationBeanPostProcessor.this.destroyAnnotationType) != null) {
                    newMetadata.addDestroyMethod(method);
                    if (debug) {
                        InitDestroyAnnotationBeanPostProcessor.this.logger.debug((Object)("Found destroy method on class [" + clazz.getName() + "]: " + method));
                    }
                }
            }
        });
        return newMetadata;
    }

    private static class LifecycleElement {
        private final Method method;

        public LifecycleElement(Method method) {
            if (method.getParameterTypes().length != 0) {
                throw new IllegalStateException("Lifecycle method annotation requires a no-arg method: " + method);
            }
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        public void invoke(Object target) throws Throwable {
            ReflectionUtils.makeAccessible((Method)this.method);
            this.method.invoke(target, null);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LifecycleElement)) {
                return false;
            }
            LifecycleElement otherElement = (LifecycleElement)other;
            return this.method.getName().equals(otherElement.method.getName()) && this.method.getDeclaringClass().equals(otherElement.method.getDeclaringClass());
        }

        public int hashCode() {
            return this.method.getName().hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LifecycleMetadata {
        private final Set<LifecycleElement> initMethods = new LinkedHashSet<LifecycleElement>();
        private final Set<LifecycleElement> destroyMethods = new LinkedHashSet<LifecycleElement>();

        private LifecycleMetadata() {
        }

        public void addInitMethod(Method method) {
            this.initMethods.add(new LifecycleElement(method));
        }

        public Set<LifecycleElement> getInitMethods() {
            return this.initMethods;
        }

        public void invokeInitMethods(Object target, String beanName) throws Throwable {
            if (!this.initMethods.isEmpty()) {
                boolean debug = InitDestroyAnnotationBeanPostProcessor.this.logger.isDebugEnabled();
                for (LifecycleElement element : this.initMethods) {
                    if (debug) {
                        InitDestroyAnnotationBeanPostProcessor.this.logger.debug((Object)("Invoking init method on bean '" + beanName + "': " + element.getMethod()));
                    }
                    element.invoke(target);
                }
            }
        }

        public void addDestroyMethod(Method method) {
            this.destroyMethods.add(new LifecycleElement(method));
        }

        public Set<LifecycleElement> getDestroyMethods() {
            return this.destroyMethods;
        }

        public void invokeDestroyMethods(Object target, String beanName) throws Throwable {
            if (!this.destroyMethods.isEmpty()) {
                boolean debug = InitDestroyAnnotationBeanPostProcessor.this.logger.isDebugEnabled();
                for (LifecycleElement element : this.destroyMethods) {
                    if (debug) {
                        InitDestroyAnnotationBeanPostProcessor.this.logger.debug((Object)("Invoking destroy method on bean '" + beanName + "': " + element.getMethod()));
                    }
                    element.invoke(target);
                }
            }
        }
    }
}

