/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyDescriptor {
    private MethodParameter methodParameter;
    private Field field;
    private final boolean required;
    private final boolean eager;
    private Annotation[] fieldAnnotations;

    public DependencyDescriptor(MethodParameter methodParameter, boolean required) {
        this(methodParameter, required, true);
    }

    public DependencyDescriptor(MethodParameter methodParameter, boolean required, boolean eager) {
        Assert.notNull((Object)methodParameter, (String)"MethodParameter must not be null");
        this.methodParameter = methodParameter;
        this.required = required;
        this.eager = eager;
    }

    public DependencyDescriptor(Field field, boolean required) {
        this(field, required, true);
    }

    public DependencyDescriptor(Field field, boolean required, boolean eager) {
        Assert.notNull((Object)field, (String)"Field must not be null");
        this.field = field;
        this.required = required;
        this.eager = eager;
    }

    public MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    public Field getField() {
        return this.field;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isEager() {
        return this.eager;
    }

    public void initParameterNameDiscovery(ParameterNameDiscoverer parameterNameDiscoverer) {
        if (this.methodParameter != null) {
            this.methodParameter.initParameterNameDiscovery(parameterNameDiscoverer);
        }
    }

    public String getDependencyName() {
        return this.field != null ? this.field.getName() : this.methodParameter.getParameterName();
    }

    public Class<?> getDependencyType() {
        return this.field != null ? this.field.getType() : this.methodParameter.getParameterType();
    }

    public Class<?> getCollectionType() {
        return this.field != null ? GenericCollectionTypeResolver.getCollectionFieldType((Field)this.field) : GenericCollectionTypeResolver.getCollectionParameterType((MethodParameter)this.methodParameter);
    }

    public Class<?> getMapKeyType() {
        return this.field != null ? GenericCollectionTypeResolver.getMapKeyFieldType((Field)this.field) : GenericCollectionTypeResolver.getMapKeyParameterType((MethodParameter)this.methodParameter);
    }

    public Class<?> getMapValueType() {
        return this.field != null ? GenericCollectionTypeResolver.getMapValueFieldType((Field)this.field) : GenericCollectionTypeResolver.getMapValueParameterType((MethodParameter)this.methodParameter);
    }

    public Annotation[] getAnnotations() {
        if (this.field != null) {
            if (this.fieldAnnotations == null) {
                this.fieldAnnotations = this.field.getAnnotations();
            }
            return this.fieldAnnotations;
        }
        return this.methodParameter.getParameterAnnotations();
    }
}

