/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.parsing;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemCollector;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.core.io.DescriptiveResource;
import org.springframework.core.io.Resource;

public class SimpleProblemCollector
implements ProblemCollector {
    private Location location = null;
    private List<Problem> errors = new ArrayList<Problem>();

    public SimpleProblemCollector(Object location) {
        if (location != null) {
            this.location = new Location((Resource)new DescriptiveResource(location.toString()));
        }
    }

    public void error(String message) {
        this.errors.add(new Problem(message, this.location));
    }

    public void error(String message, Throwable cause) {
        this.errors.add(new Problem(message, this.location, null, cause));
    }

    public void reportProblems(ProblemReporter reporter) {
        for (Problem error : this.errors) {
            reporter.error(error);
        }
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }
}

