/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Method;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;

public class GenericTypeAwareAutowireCandidateResolver
implements AutowireCandidateResolver,
BeanFactoryAware {
    private BeanFactory beanFactory;

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected final BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Override
    public boolean isAutowireCandidate(BeanDefinitionHolder bdHolder, DependencyDescriptor descriptor) {
        if (!bdHolder.getBeanDefinition().isAutowireCandidate()) {
            return false;
        }
        return descriptor == null || this.checkGenericTypeMatch(bdHolder, descriptor);
    }

    protected boolean checkGenericTypeMatch(BeanDefinitionHolder bdHolder, DependencyDescriptor descriptor) {
        ResolvableType dependencyType = descriptor.getResolvableType();
        if (dependencyType.getType() instanceof Class) {
            return true;
        }
        ResolvableType targetType = null;
        RootBeanDefinition rbd = null;
        if (bdHolder.getBeanDefinition() instanceof RootBeanDefinition) {
            rbd = (RootBeanDefinition)bdHolder.getBeanDefinition();
        }
        if (rbd != null && rbd.getFactoryMethodName() != null) {
            Class<?> preResolved = rbd.resolvedFactoryMethodReturnType;
            if (preResolved != null) {
                targetType = ResolvableType.forClass(preResolved);
            } else {
                Method resolvedFactoryMethod = rbd.getResolvedFactoryMethod();
                if (resolvedFactoryMethod != null && descriptor.getDependencyType().isAssignableFrom(resolvedFactoryMethod.getReturnType())) {
                    targetType = ResolvableType.forMethodReturnType((Method)resolvedFactoryMethod);
                }
            }
        }
        if (targetType == null) {
            Class<?> beanClass;
            Class<?> beanType;
            if (this.beanFactory != null && (beanType = this.beanFactory.getType(bdHolder.getBeanName())) != null) {
                targetType = ResolvableType.forClass((Class)ClassUtils.getUserClass(beanType));
            }
            if (targetType == null && rbd != null && rbd.hasBeanClass() && rbd.getFactoryMethodName() == null && !FactoryBean.class.isAssignableFrom(beanClass = rbd.getBeanClass())) {
                targetType = ResolvableType.forClass((Class)ClassUtils.getUserClass(beanClass));
            }
        }
        if (targetType == null) {
            return true;
        }
        if (descriptor.fallbackMatchAllowed() && targetType.hasUnresolvableGenerics()) {
            return descriptor.getDependencyType().isAssignableFrom(targetType.getRawClass());
        }
        return dependencyType.isAssignableFrom(targetType);
    }

    @Override
    public Object getSuggestedValue(DependencyDescriptor descriptor) {
        return null;
    }

    @Override
    public Object getLazyResolutionProxyIfNecessary(DependencyDescriptor descriptor, String beanName) {
        return null;
    }
}

