/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ReplaceOverride
extends MethodOverride {
    private final String methodReplacerBeanName;
    private final List<String> typeIdentifiers = new LinkedList<String>();

    public ReplaceOverride(String methodName, String methodReplacerBeanName) {
        super(methodName);
        Assert.notNull((Object)methodReplacerBeanName, (String)"Method replacer bean name must not be null");
        this.methodReplacerBeanName = methodReplacerBeanName;
    }

    public String getMethodReplacerBeanName() {
        return this.methodReplacerBeanName;
    }

    public void addTypeIdentifier(String identifier) {
        this.typeIdentifiers.add(identifier);
    }

    @Override
    public boolean matches(Method method) {
        if (!method.getName().equals(this.getMethodName())) {
            return false;
        }
        if (!this.isOverloaded()) {
            return true;
        }
        if (this.typeIdentifiers.size() != method.getParameterCount()) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < this.typeIdentifiers.size(); ++i) {
            String identifier = this.typeIdentifiers.get(i);
            if (parameterTypes[i].getName().contains(identifier)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ReplaceOverride) || !super.equals(other)) {
            return false;
        }
        ReplaceOverride that = (ReplaceOverride)other;
        return ObjectUtils.nullSafeEquals((Object)this.methodReplacerBeanName, (Object)that.methodReplacerBeanName) && ObjectUtils.nullSafeEquals(this.typeIdentifiers, that.typeIdentifiers);
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.methodReplacerBeanName);
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode(this.typeIdentifiers);
        return hashCode;
    }

    public String toString() {
        return "Replace override for method '" + this.getMethodName() + "'";
    }
}

