/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.method;

import java.lang.reflect.Method;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.support.DefaultConversionService;
import org.springframework.binding.method.ClassMethodKey;
import org.springframework.binding.method.MethodInvocationException;
import org.springframework.binding.method.MethodSignature;
import org.springframework.binding.method.Parameter;
import org.springframework.binding.method.Parameters;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.CachingMapDecorator;

public class MethodInvoker {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$binding$method$MethodInvoker == null ? (class$org$springframework$binding$method$MethodInvoker = MethodInvoker.class$("org.springframework.binding.method.MethodInvoker")) : class$org$springframework$binding$method$MethodInvoker));
    private ConversionService conversionService = new DefaultConversionService();
    private CachingMapDecorator methodCache = new CachingMapDecorator(true){

        public Object create(Object key) {
            return ((ClassMethodKey)key).getMethod();
        }
    };
    static /* synthetic */ Class class$org$springframework$binding$method$MethodInvoker;

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Object invoke(MethodSignature signature, Object bean, Object parameterValueSource) throws MethodInvocationException {
        Object parameterValue;
        Parameters parameters = signature.getParameters();
        Object[] parameterValues = new Object[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = parameters.getParameter(i);
            parameterValue = parameter.getName().evaluateAgainst(parameterValueSource, Collections.EMPTY_MAP);
            parameterValues[i] = this.applyTypeConversion(parameterValue, parameter.getType());
        }
        Class[] parameterTypes = parameters.getTypesArray();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] != null || (parameterValue = parameterValues[i]) == null) continue;
            parameterTypes[i] = parameterValue.getClass();
        }
        ClassMethodKey key = new ClassMethodKey(bean.getClass(), signature.getMethodName(), parameterTypes);
        try {
            Method method = (Method)this.methodCache.get((Object)key);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking method with signature [" + key + "] with arguments " + StylerUtils.style((Object)parameterValues) + " on bean [" + bean + "]"));
            }
            Object returnValue = method.invoke(bean, parameterValues);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoked method with signature [" + key + "]' returned value [" + returnValue + "]"));
            }
            return returnValue;
        }
        catch (Exception e) {
            throw new MethodInvocationException(key, parameterValues, e);
        }
    }

    protected Object applyTypeConversion(Object parameterValue, Class targetType) {
        if (parameterValue == null || targetType == null) {
            return parameterValue;
        }
        return this.conversionService.getConversionExecutor(parameterValue.getClass(), targetType).execute(parameterValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

