/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.method;

import java.lang.reflect.InvocationTargetException;
import org.springframework.binding.method.MethodSignature;
import org.springframework.core.NestedRuntimeException;
import org.springframework.core.style.StylerUtils;

public class MethodInvocationException
extends NestedRuntimeException {
    private MethodSignature methodSignature;
    private Object[] arguments;

    public MethodInvocationException(MethodSignature methodSignature, Object[] arguments, Exception cause) {
        super("Unable to invoke method " + methodSignature + " with arguments " + StylerUtils.style((Object)arguments), (Throwable)cause);
    }

    public MethodSignature getMethodSignature() {
        return this.methodSignature;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public Throwable getTargetException() {
        if (this.getCause() instanceof InvocationTargetException) {
            return ((InvocationTargetException)this.getCause()).getTargetException();
        }
        return this.getCause();
    }
}

