/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.method;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.binding.method.InvalidMethodSignatureException;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.ObjectUtils;

public class ClassMethodKey
implements Serializable {
    private Class type;
    private String methodName;
    private Class[] parameterTypes;
    private transient Method method;
    private static final Map primitiveWrapperTypeMap = new HashMap(8);
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public ClassMethodKey(Class type, String methodName, Class[] parameterTypes) {
        this.type = type;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
    }

    public Class getType() {
        return this.type;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Method getMethod() throws InvalidMethodSignatureException {
        if (this.method == null) {
            this.method = this.resolveMethod();
        }
        return this.method;
    }

    protected Method resolveMethod() throws InvalidMethodSignatureException {
        try {
            return this.type.getMethod(this.getMethodName(), this.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            Method method = this.findMethodConsiderAssignableParameterTypes();
            if (method != null) {
                return method;
            }
            throw new InvalidMethodSignatureException(this, e);
        }
    }

    protected Method findMethodConsiderAssignableParameterTypes() {
        Method[] candidateMethods = this.getType().getMethods();
        for (int i = 0; i < candidateMethods.length; ++i) {
            Class<?>[] candidateParameterTypes;
            if (!candidateMethods[i].getName().equals(this.getMethodName()) || (candidateParameterTypes = candidateMethods[i].getParameterTypes()).length != this.getParameterTypes().length) continue;
            int numberOfCorrectArguments = 0;
            for (int j = 0; j < candidateParameterTypes.length; ++j) {
                Class<?> candidateType = candidateParameterTypes[j];
                Class parameterType = this.parameterTypes[j];
                if (parameterType != null) {
                    if (!ClassMethodKey.isAssignable(candidateType, parameterType)) continue;
                    ++numberOfCorrectArguments;
                    continue;
                }
                ++numberOfCorrectArguments;
            }
            if (numberOfCorrectArguments != this.parameterTypes.length) continue;
            return candidateMethods[i];
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassMethodKey)) {
            return false;
        }
        ClassMethodKey other = (ClassMethodKey)obj;
        return this.type.equals(other.type) && this.methodName.equals(other.methodName) && this.argumentTypesEqual(other.parameterTypes);
    }

    private boolean argumentTypesEqual(Class[] other) {
        if (this.parameterTypes == other) {
            return true;
        }
        if (this.parameterTypes.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (ObjectUtils.nullSafeEquals((Object)this.parameterTypes[i], (Object)other[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.type.hashCode() + this.methodName.hashCode() + this.argumentTypesHash();
    }

    private int argumentTypesHash() {
        if (this.parameterTypes == null) {
            return 0;
        }
        int hash = 0;
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            Class parameterType = this.parameterTypes[i];
            if (parameterType == null) continue;
            hash += this.parameterTypes[i].hashCode();
        }
        return hash;
    }

    private static boolean isAssignable(Class targetType, Class valueType) {
        return targetType.isAssignableFrom(valueType) || targetType.equals(primitiveWrapperTypeMap.get(valueType));
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("class", (Object)this.type).append("methodName", (Object)this.methodName).append("parameterTypes", (Object)this.parameterTypes).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        primitiveWrapperTypeMap.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassMethodKey.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Byte == null ? (class$java$lang$Byte = ClassMethodKey.class$("java.lang.Byte")) : class$java$lang$Byte, Byte.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Character == null ? (class$java$lang$Character = ClassMethodKey.class$("java.lang.Character")) : class$java$lang$Character, Character.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Double == null ? (class$java$lang$Double = ClassMethodKey.class$("java.lang.Double")) : class$java$lang$Double, Double.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Float == null ? (class$java$lang$Float = ClassMethodKey.class$("java.lang.Float")) : class$java$lang$Float, Float.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Integer == null ? (class$java$lang$Integer = ClassMethodKey.class$("java.lang.Integer")) : class$java$lang$Integer, Integer.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Long == null ? (class$java$lang$Long = ClassMethodKey.class$("java.lang.Long")) : class$java$lang$Long, Long.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Short == null ? (class$java$lang$Short = ClassMethodKey.class$("java.lang.Short")) : class$java$lang$Short, Short.TYPE);
    }
}

