/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.beans.PropertyEditorSupport;
import org.springframework.cache.interceptor.CacheEvictOperation;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CacheUpdateOperation;
import org.springframework.util.StringUtils;

public class CacheOperationEditor
extends PropertyEditorSupport {
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasLength((String)text)) {
            CacheOperation op;
            String[] tokens = StringUtils.commaDelimitedListToStringArray((String)text);
            if (tokens.length < 2) {
                throw new IllegalArgumentException("too little arguments found, at least the cache action and cache name are required");
            }
            if ("cacheable".contains(tokens[0])) {
                op = new CacheUpdateOperation();
            } else if ("evict".contains(tokens[0])) {
                op = new CacheEvictOperation();
            } else {
                throw new IllegalArgumentException("Invalid cache action specified " + tokens[0]);
            }
            op.setCacheNames(StringUtils.delimitedListToStringArray((String)tokens[1], (String)";"));
            if (tokens.length > 2) {
                op.setKey(tokens[2]);
            }
            if (tokens.length > 3) {
                op.setCondition(tokens[3]);
            }
            this.setValue(op);
        } else {
            this.setValue(null);
        }
    }
}

