/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.BeanMethod;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScanAnnotationParser;
import org.springframework.context.annotation.ConfigurationClass;
import org.springframework.context.annotation.ConfigurationClassUtils;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.context.annotation.MetadataUtils;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationClassParser {
    private final MetadataReaderFactory metadataReaderFactory;
    private final ProblemReporter problemReporter;
    private final ImportStack importStack = new ImportStack();
    private final Set<String> knownSuperclasses = new LinkedHashSet<String>();
    private final Set<ConfigurationClass> configurationClasses = new LinkedHashSet<ConfigurationClass>();
    private final Stack<org.springframework.core.env.PropertySource<?>> propertySources = new Stack();
    private final Environment environment;
    private final ResourceLoader resourceLoader;
    private final BeanDefinitionRegistry registry;
    private final ComponentScanAnnotationParser componentScanParser;

    public ConfigurationClassParser(MetadataReaderFactory metadataReaderFactory, ProblemReporter problemReporter, Environment environment, ResourceLoader resourceLoader, BeanNameGenerator componentScanBeanNameGenerator, BeanDefinitionRegistry registry) {
        this.metadataReaderFactory = metadataReaderFactory;
        this.problemReporter = problemReporter;
        this.environment = environment;
        this.resourceLoader = resourceLoader;
        this.registry = registry;
        this.componentScanParser = new ComponentScanAnnotationParser(resourceLoader, environment, componentScanBeanNameGenerator, registry);
    }

    public void parse(String className, String beanName) throws IOException {
        MetadataReader reader = this.metadataReaderFactory.getMetadataReader(className);
        this.processConfigurationClass(new ConfigurationClass(reader, beanName));
    }

    public void parse(Class<?> clazz, String beanName) throws IOException {
        this.processConfigurationClass(new ConfigurationClass(clazz, beanName));
    }

    protected void processConfigurationClass(ConfigurationClass configClass) throws IOException {
        AnnotationAttributes profile;
        AnnotationMetadata metadata = configClass.getMetadata();
        if (this.environment != null && metadata.isAnnotated(Profile.class.getName()) && !this.environment.acceptsProfiles((profile = MetadataUtils.attributesFor(metadata, Profile.class)).getStringArray("value"))) {
            return;
        }
        while ((metadata = this.doProcessConfigurationClass(configClass, metadata)) != null) {
        }
        if (this.configurationClasses.contains(configClass) && configClass.getBeanName() != null) {
            this.configurationClasses.remove(configClass);
        }
        this.configurationClasses.add(configClass);
    }

    protected AnnotationMetadata doProcessConfigurationClass(ConfigurationClass configClass, AnnotationMetadata metadata) throws IOException {
        String superclass;
        AnnotationAttributes componentScan;
        for (String memberClassName : metadata.getMemberClassNames()) {
            MetadataReader reader = this.metadataReaderFactory.getMetadataReader(memberClassName);
            AnnotationMetadata memberClassMetadata = reader.getAnnotationMetadata();
            if (!ConfigurationClassUtils.isConfigurationCandidate(memberClassMetadata)) continue;
            this.processConfigurationClass(new ConfigurationClass(reader, true));
        }
        AnnotationAttributes propertySource = MetadataUtils.attributesFor(metadata, PropertySource.class);
        if (propertySource != null) {
            String name = propertySource.getString("name");
            String[] locations = propertySource.getStringArray("value");
            int nLocations = locations.length;
            if (nLocations == 0) {
                throw new IllegalArgumentException("At least one @PropertySource(value) location is required");
            }
            for (int i = 0; i < nLocations; ++i) {
                locations[i] = this.environment.resolveRequiredPlaceholders(locations[i]);
            }
            ClassLoader classLoader = this.resourceLoader.getClassLoader();
            if (!StringUtils.hasText((String)name)) {
                for (String location : locations) {
                    this.propertySources.push((org.springframework.core.env.PropertySource<?>)new ResourcePropertySource(location, classLoader));
                }
            } else if (nLocations == 1) {
                this.propertySources.push((org.springframework.core.env.PropertySource<?>)new ResourcePropertySource(name, locations[0], classLoader));
            } else {
                CompositePropertySource ps = new CompositePropertySource(name);
                for (String location : locations) {
                    ps.addPropertySource((org.springframework.core.env.PropertySource)new ResourcePropertySource(location, classLoader));
                }
                this.propertySources.push((org.springframework.core.env.PropertySource<?>)ps);
            }
        }
        if ((componentScan = MetadataUtils.attributesFor(metadata, ComponentScan.class)) != null) {
            Set<BeanDefinitionHolder> scannedBeanDefinitions = this.componentScanParser.parse(componentScan, metadata.getClassName());
            for (BeanDefinitionHolder holder : scannedBeanDefinitions) {
                if (!ConfigurationClassUtils.checkConfigurationClassCandidate(holder.getBeanDefinition(), this.metadataReaderFactory)) continue;
                this.parse(holder.getBeanDefinition().getBeanClassName(), holder.getBeanName());
            }
        }
        List<AnnotationAttributes> imports = this.findAllAnnotationAttributes(Import.class, metadata.getClassName(), true);
        for (AnnotationAttributes importAnno : imports) {
            this.processImport(configClass, importAnno.getStringArray("value"), true);
        }
        if (metadata.isAnnotated(ImportResource.class.getName())) {
            AnnotationAttributes importResource = MetadataUtils.attributesFor(metadata, ImportResource.class);
            String[] resources = importResource.getStringArray("value");
            Class readerClass = importResource.getClass("reader");
            for (String resource : resources) {
                configClass.addImportedResource(resource, readerClass);
            }
        }
        Set beanMethods = metadata.getAnnotatedMethods(Bean.class.getName());
        for (MethodMetadata methodMetadata : beanMethods) {
            configClass.addBeanMethod(new BeanMethod(methodMetadata, configClass));
        }
        if (metadata.hasSuperClass() && this.knownSuperclasses.add(superclass = metadata.getSuperClassName())) {
            if (metadata instanceof StandardAnnotationMetadata) {
                Class clazz = ((StandardAnnotationMetadata)metadata).getIntrospectedClass();
                return new StandardAnnotationMetadata(clazz.getSuperclass(), true);
            }
            MetadataReader reader = this.metadataReaderFactory.getMetadataReader(superclass);
            return reader.getAnnotationMetadata();
        }
        return null;
    }

    private List<AnnotationAttributes> findAllAnnotationAttributes(Class<? extends Annotation> targetAnnotation, String annotatedClassName, boolean classValuesAsString) throws IOException {
        ArrayList<AnnotationAttributes> allAttribs = new ArrayList<AnnotationAttributes>();
        MetadataReader reader = this.metadataReaderFactory.getMetadataReader(annotatedClassName);
        AnnotationMetadata metadata = reader.getAnnotationMetadata();
        String targetAnnotationType = targetAnnotation.getName();
        for (String annotationType : metadata.getAnnotationTypes()) {
            AnnotationMetadata metaAnnotations;
            AnnotationAttributes targetAttribs;
            if (annotationType.equals(targetAnnotationType) || (targetAttribs = AnnotationAttributes.fromMap((Map)(metaAnnotations = this.metadataReaderFactory.getMetadataReader(annotationType).getAnnotationMetadata()).getAnnotationAttributes(targetAnnotationType, classValuesAsString))) == null) continue;
            allAttribs.add(targetAttribs);
        }
        AnnotationAttributes localAttribs = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(targetAnnotationType, classValuesAsString));
        if (localAttribs != null) {
            allAttribs.add(localAttribs);
        }
        return allAttribs;
    }

    private void processImport(ConfigurationClass configClass, String[] classesToImport, boolean checkForCircularImports) throws IOException {
        if (checkForCircularImports && this.importStack.contains(configClass)) {
            this.problemReporter.error((Problem)new CircularImportProblem(configClass, this.importStack, configClass.getMetadata()));
        } else {
            this.importStack.push(configClass);
            AnnotationMetadata importingClassMetadata = configClass.getMetadata();
            for (String candidate : classesToImport) {
                MetadataReader reader = this.metadataReaderFactory.getMetadataReader(candidate);
                if (new AssignableTypeFilter(ImportSelector.class).match(reader, this.metadataReaderFactory)) {
                    try {
                        ImportSelector selector = (ImportSelector)BeanUtils.instantiateClass(Class.forName(candidate), ImportSelector.class);
                        this.processImport(configClass, selector.selectImports(importingClassMetadata), false);
                        continue;
                    }
                    catch (ClassNotFoundException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
                if (new AssignableTypeFilter(ImportBeanDefinitionRegistrar.class).match(reader, this.metadataReaderFactory)) {
                    try {
                        ImportBeanDefinitionRegistrar registrar = (ImportBeanDefinitionRegistrar)BeanUtils.instantiateClass(Class.forName(candidate), ImportBeanDefinitionRegistrar.class);
                        registrar.registerBeanDefinitions(importingClassMetadata, this.registry);
                        continue;
                    }
                    catch (ClassNotFoundException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
                this.importStack.registerImport(importingClassMetadata.getClassName(), candidate);
                this.processConfigurationClass(new ConfigurationClass(reader, true));
            }
            this.importStack.pop();
        }
    }

    public void validate() {
        for (ConfigurationClass configClass : this.configurationClasses) {
            configClass.validate(this.problemReporter);
        }
    }

    public Set<ConfigurationClass> getConfigurationClasses() {
        return this.configurationClasses;
    }

    public Stack<org.springframework.core.env.PropertySource<?>> getPropertySources() {
        return this.propertySources;
    }

    public ImportRegistry getImportRegistry() {
        return this.importStack;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CircularImportProblem
    extends Problem {
        public CircularImportProblem(ConfigurationClass attemptedImport, Stack<ConfigurationClass> importStack, AnnotationMetadata metadata) {
            super(String.format("A circular @Import has been detected: Illegal attempt by @Configuration class '%s' to import class '%s' as '%s' is already present in the current import stack [%s]", importStack.peek().getSimpleName(), attemptedImport.getSimpleName(), attemptedImport.getSimpleName(), importStack), new Location(importStack.peek().getResource(), (Object)metadata));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImportStack
    extends Stack<ConfigurationClass>
    implements ImportRegistry {
        private final Map<String, String> imports = new HashMap<String, String>();

        private ImportStack() {
        }

        public void registerImport(String importingClass, String importedClass) {
            this.imports.put(importedClass, importingClass);
        }

        @Override
        public String getImportingClassFor(String importedClass) {
            return this.imports.get(importedClass);
        }

        @Override
        public boolean contains(Object elem) {
            ConfigurationClass configClass = (ConfigurationClass)elem;
            Comparator<ConfigurationClass> comparator = new Comparator<ConfigurationClass>(){

                @Override
                public int compare(ConfigurationClass first, ConfigurationClass second) {
                    return first.getMetadata().getClassName().equals(second.getMetadata().getClassName()) ? 0 : 1;
                }
            };
            return Collections.binarySearch(this, configClass, comparator) != -1;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder("ImportStack: [");
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                builder.append(((ConfigurationClass)iterator.next()).getSimpleName());
                if (!iterator.hasNext()) continue;
                builder.append("->");
            }
            return builder.append(']').toString();
        }
    }

    static interface ImportRegistry {
        public String getImportingClassFor(String var1);
    }
}

