/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.datetime.joda;

import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;

final class JodaTimeConverters {
    JodaTimeConverters() {
    }

    public static void registerConverters(ConverterRegistry registry) {
        registry.addConverter((Converter)new DateTimeToLocalDateConverter());
        registry.addConverter((Converter)new DateTimeToLocalTimeConverter());
        registry.addConverter((Converter)new DateTimeToLocalDateTimeConverter());
        registry.addConverter((Converter)new DateTimeToDateMidnightConverter());
        registry.addConverter((Converter)new DateTimeToInstantConverter());
        registry.addConverter((Converter)new DateTimeToMutableDateTimeConverter());
        registry.addConverter((Converter)new DateTimeToDateConverter());
        registry.addConverter((Converter)new DateTimeToCalendarConverter());
        registry.addConverter((Converter)new DateTimeToLongConverter());
        registry.addConverter((Converter)new DateToLongConverter());
        registry.addConverter((Converter)new CalendarToReadableInstantConverter());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CalendarToReadableInstantConverter
    implements Converter<Calendar, ReadableInstant> {
        private CalendarToReadableInstantConverter() {
        }

        public ReadableInstant convert(Calendar source) {
            return new DateTime((Object)source);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateToLongConverter
    implements Converter<Date, Long> {
        private DateToLongConverter() {
        }

        public Long convert(Date source) {
            return source.getTime();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateTimeToLongConverter
    implements Converter<DateTime, Long> {
        private DateTimeToLongConverter() {
        }

        public Long convert(DateTime source) {
            return source.getMillis();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateTimeToCalendarConverter
    implements Converter<DateTime, Calendar> {
        private DateTimeToCalendarConverter() {
        }

        public Calendar convert(DateTime source) {
            return source.toGregorianCalendar();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateTimeToDateConverter
    implements Converter<DateTime, Date> {
        private DateTimeToDateConverter() {
        }

        public Date convert(DateTime source) {
            return source.toDate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateTimeToMutableDateTimeConverter
    implements Converter<DateTime, MutableDateTime> {
        private DateTimeToMutableDateTimeConverter() {
        }

        public MutableDateTime convert(DateTime source) {
            return source.toMutableDateTime();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateTimeToInstantConverter
    implements Converter<DateTime, Instant> {
        private DateTimeToInstantConverter() {
        }

        public Instant convert(DateTime source) {
            return source.toInstant();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateTimeToDateMidnightConverter
    implements Converter<DateTime, DateMidnight> {
        private DateTimeToDateMidnightConverter() {
        }

        public DateMidnight convert(DateTime source) {
            return source.toDateMidnight();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateTimeToLocalDateTimeConverter
    implements Converter<DateTime, LocalDateTime> {
        private DateTimeToLocalDateTimeConverter() {
        }

        public LocalDateTime convert(DateTime source) {
            return source.toLocalDateTime();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateTimeToLocalTimeConverter
    implements Converter<DateTime, LocalTime> {
        private DateTimeToLocalTimeConverter() {
        }

        public LocalTime convert(DateTime source) {
            return source.toLocalTime();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateTimeToLocalDateConverter
    implements Converter<DateTime, LocalDate> {
        private DateTimeToLocalDateConverter() {
        }

        public LocalDate convert(DateTime source) {
            return source.toLocalDate();
        }
    }
}

