/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.support.ResourceEditorRegistrar;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.LifecycleProcessor;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.ContextStartedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.context.support.ApplicationContextAwareProcessor;
import org.springframework.context.support.ContextTypeMatchClassLoader;
import org.springframework.context.support.DefaultLifecycleProcessor;
import org.springframework.context.support.DelegatingMessageSource;
import org.springframework.context.support.LiveBeansView;
import org.springframework.context.support.PostProcessorRegistrationDelegate;
import org.springframework.context.weaving.LoadTimeWeaverAware;
import org.springframework.context.weaving.LoadTimeWeaverAwareProcessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class AbstractApplicationContext
extends DefaultResourceLoader
implements ConfigurableApplicationContext,
DisposableBean {
    public static final String MESSAGE_SOURCE_BEAN_NAME = "messageSource";
    public static final String LIFECYCLE_PROCESSOR_BEAN_NAME = "lifecycleProcessor";
    public static final String APPLICATION_EVENT_MULTICASTER_BEAN_NAME = "applicationEventMulticaster";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String id = ObjectUtils.identityToString((Object)this);
    private String displayName = ObjectUtils.identityToString((Object)this);
    private ApplicationContext parent;
    private final List<BeanFactoryPostProcessor> beanFactoryPostProcessors = new ArrayList<BeanFactoryPostProcessor>();
    private long startupDate;
    private boolean active = false;
    private boolean closed = false;
    private final Object activeMonitor = new Object();
    private final Object startupShutdownMonitor = new Object();
    private Thread shutdownHook;
    private ResourcePatternResolver resourcePatternResolver;
    private LifecycleProcessor lifecycleProcessor;
    private MessageSource messageSource;
    private ApplicationEventMulticaster applicationEventMulticaster;
    private Set<ApplicationListener<?>> applicationListeners = new LinkedHashSet();
    private ConfigurableEnvironment environment;

    public AbstractApplicationContext() {
        this(null);
    }

    public AbstractApplicationContext(ApplicationContext parent) {
        this.parent = parent;
        this.resourcePatternResolver = this.getResourcePatternResolver();
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getApplicationName() {
        return "";
    }

    public void setDisplayName(String displayName) {
        Assert.hasLength((String)displayName, (String)"Display name must not be empty");
        this.displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public ApplicationContext getParent() {
        return this.parent;
    }

    @Override
    public ConfigurableEnvironment getEnvironment() {
        if (this.environment == null) {
            this.environment = this.createEnvironment();
        }
        return this.environment;
    }

    @Override
    public void setEnvironment(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public AutowireCapableBeanFactory getAutowireCapableBeanFactory() throws IllegalStateException {
        return this.getBeanFactory();
    }

    @Override
    public long getStartupDate() {
        return this.startupDate;
    }

    @Override
    public void publishEvent(ApplicationEvent event) {
        Assert.notNull((Object)event, (String)"Event must not be null");
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Publishing event in " + this.getDisplayName() + ": " + event));
        }
        this.getApplicationEventMulticaster().multicastEvent(event);
        if (this.parent != null) {
            this.parent.publishEvent(event);
        }
    }

    private ApplicationEventMulticaster getApplicationEventMulticaster() throws IllegalStateException {
        if (this.applicationEventMulticaster == null) {
            throw new IllegalStateException("ApplicationEventMulticaster not initialized - call 'refresh' before multicasting events via the context: " + this);
        }
        return this.applicationEventMulticaster;
    }

    private LifecycleProcessor getLifecycleProcessor() {
        if (this.lifecycleProcessor == null) {
            throw new IllegalStateException("LifecycleProcessor not initialized - call 'refresh' before invoking lifecycle methods via the context: " + this);
        }
        return this.lifecycleProcessor;
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return new PathMatchingResourcePatternResolver((ResourceLoader)this);
    }

    @Override
    public void setParent(ApplicationContext parent) {
        Environment parentEnvironment;
        this.parent = parent;
        if (parent != null && (parentEnvironment = parent.getEnvironment()) instanceof ConfigurableEnvironment) {
            this.getEnvironment().merge((ConfigurableEnvironment)parentEnvironment);
        }
    }

    @Override
    public void addBeanFactoryPostProcessor(BeanFactoryPostProcessor beanFactoryPostProcessor) {
        this.beanFactoryPostProcessors.add(beanFactoryPostProcessor);
    }

    public List<BeanFactoryPostProcessor> getBeanFactoryPostProcessors() {
        return this.beanFactoryPostProcessors;
    }

    @Override
    public void addApplicationListener(ApplicationListener<?> listener) {
        if (this.applicationEventMulticaster != null) {
            this.applicationEventMulticaster.addApplicationListener(listener);
        } else {
            this.applicationListeners.add(listener);
        }
    }

    public Collection<ApplicationListener<?>> getApplicationListeners() {
        return this.applicationListeners;
    }

    protected ConfigurableEnvironment createEnvironment() {
        return new StandardEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws BeansException, IllegalStateException {
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            this.prepareRefresh();
            ConfigurableListableBeanFactory beanFactory = this.obtainFreshBeanFactory();
            this.prepareBeanFactory(beanFactory);
            try {
                this.postProcessBeanFactory(beanFactory);
                this.invokeBeanFactoryPostProcessors(beanFactory);
                this.registerBeanPostProcessors(beanFactory);
                this.initMessageSource();
                this.initApplicationEventMulticaster();
                this.onRefresh();
                this.registerListeners();
                this.finishBeanFactoryInitialization(beanFactory);
                this.finishRefresh();
            }
            catch (BeansException ex) {
                this.destroyBeans();
                this.cancelRefresh(ex);
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareRefresh() {
        this.startupDate = System.currentTimeMillis();
        Object object = this.activeMonitor;
        synchronized (object) {
            this.active = true;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Refreshing " + this));
        }
        this.initPropertySources();
        this.getEnvironment().validateRequiredProperties();
    }

    protected void initPropertySources() {
    }

    protected ConfigurableListableBeanFactory obtainFreshBeanFactory() {
        this.refreshBeanFactory();
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Bean factory for " + this.getDisplayName() + ": " + beanFactory));
        }
        return beanFactory;
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.setBeanClassLoader(this.getClassLoader());
        beanFactory.setBeanExpressionResolver((BeanExpressionResolver)new StandardBeanExpressionResolver());
        beanFactory.addPropertyEditorRegistrar((PropertyEditorRegistrar)new ResourceEditorRegistrar((ResourceLoader)this, (PropertyResolver)this.getEnvironment()));
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ApplicationContextAwareProcessor(this));
        beanFactory.ignoreDependencyInterface(ResourceLoaderAware.class);
        beanFactory.ignoreDependencyInterface(ApplicationEventPublisherAware.class);
        beanFactory.ignoreDependencyInterface(MessageSourceAware.class);
        beanFactory.ignoreDependencyInterface(ApplicationContextAware.class);
        beanFactory.ignoreDependencyInterface(EnvironmentAware.class);
        beanFactory.registerResolvableDependency(BeanFactory.class, (Object)beanFactory);
        beanFactory.registerResolvableDependency(ResourceLoader.class, (Object)this);
        beanFactory.registerResolvableDependency(ApplicationEventPublisher.class, (Object)this);
        beanFactory.registerResolvableDependency(ApplicationContext.class, (Object)this);
        if (beanFactory.containsBean("loadTimeWeaver")) {
            beanFactory.addBeanPostProcessor((BeanPostProcessor)new LoadTimeWeaverAwareProcessor((BeanFactory)beanFactory));
            beanFactory.setTempClassLoader((ClassLoader)((Object)new ContextTypeMatchClassLoader(beanFactory.getBeanClassLoader())));
        }
        if (!beanFactory.containsLocalBean("environment")) {
            beanFactory.registerSingleton("environment", (Object)this.getEnvironment());
        }
        if (!beanFactory.containsLocalBean("systemProperties")) {
            beanFactory.registerSingleton("systemProperties", (Object)this.getEnvironment().getSystemProperties());
        }
        if (!beanFactory.containsLocalBean("systemEnvironment")) {
            beanFactory.registerSingleton("systemEnvironment", (Object)this.getEnvironment().getSystemEnvironment());
        }
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
    }

    protected void invokeBeanFactoryPostProcessors(ConfigurableListableBeanFactory beanFactory) {
        PostProcessorRegistrationDelegate.invokeBeanFactoryPostProcessors(beanFactory, this.getBeanFactoryPostProcessors());
    }

    protected void registerBeanPostProcessors(ConfigurableListableBeanFactory beanFactory) {
        PostProcessorRegistrationDelegate.registerBeanPostProcessors(beanFactory, this);
    }

    protected void initMessageSource() {
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory.containsLocalBean(MESSAGE_SOURCE_BEAN_NAME)) {
            HierarchicalMessageSource hms;
            this.messageSource = (MessageSource)beanFactory.getBean(MESSAGE_SOURCE_BEAN_NAME, MessageSource.class);
            if (this.parent != null && this.messageSource instanceof HierarchicalMessageSource && (hms = (HierarchicalMessageSource)this.messageSource).getParentMessageSource() == null) {
                hms.setParentMessageSource(this.getInternalParentMessageSource());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using MessageSource [" + this.messageSource + "]"));
            }
        } else {
            DelegatingMessageSource dms = new DelegatingMessageSource();
            dms.setParentMessageSource(this.getInternalParentMessageSource());
            this.messageSource = dms;
            beanFactory.registerSingleton(MESSAGE_SOURCE_BEAN_NAME, (Object)this.messageSource);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Unable to locate MessageSource with name 'messageSource': using default [" + this.messageSource + "]"));
            }
        }
    }

    protected void initApplicationEventMulticaster() {
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory.containsLocalBean(APPLICATION_EVENT_MULTICASTER_BEAN_NAME)) {
            this.applicationEventMulticaster = (ApplicationEventMulticaster)beanFactory.getBean(APPLICATION_EVENT_MULTICASTER_BEAN_NAME, ApplicationEventMulticaster.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using ApplicationEventMulticaster [" + this.applicationEventMulticaster + "]"));
            }
        } else {
            this.applicationEventMulticaster = new SimpleApplicationEventMulticaster((BeanFactory)beanFactory);
            beanFactory.registerSingleton(APPLICATION_EVENT_MULTICASTER_BEAN_NAME, (Object)this.applicationEventMulticaster);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Unable to locate ApplicationEventMulticaster with name 'applicationEventMulticaster': using default [" + this.applicationEventMulticaster + "]"));
            }
        }
    }

    protected void initLifecycleProcessor() {
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory.containsLocalBean(LIFECYCLE_PROCESSOR_BEAN_NAME)) {
            this.lifecycleProcessor = (LifecycleProcessor)beanFactory.getBean(LIFECYCLE_PROCESSOR_BEAN_NAME, LifecycleProcessor.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using LifecycleProcessor [" + this.lifecycleProcessor + "]"));
            }
        } else {
            DefaultLifecycleProcessor defaultProcessor = new DefaultLifecycleProcessor();
            defaultProcessor.setBeanFactory((BeanFactory)beanFactory);
            this.lifecycleProcessor = defaultProcessor;
            beanFactory.registerSingleton(LIFECYCLE_PROCESSOR_BEAN_NAME, (Object)this.lifecycleProcessor);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Unable to locate LifecycleProcessor with name 'lifecycleProcessor': using default [" + this.lifecycleProcessor + "]"));
            }
        }
    }

    protected void onRefresh() throws BeansException {
    }

    protected void registerListeners() {
        String[] listenerBeanNames;
        for (ApplicationListener<?> listener : this.getApplicationListeners()) {
            this.getApplicationEventMulticaster().addApplicationListener(listener);
        }
        for (String lisName : listenerBeanNames = this.getBeanNamesForType(ApplicationListener.class, true, false)) {
            this.getApplicationEventMulticaster().addApplicationListenerBean(lisName);
        }
    }

    protected void finishBeanFactoryInitialization(ConfigurableListableBeanFactory beanFactory) {
        String[] weaverAwareNames;
        if (beanFactory.containsBean("conversionService") && beanFactory.isTypeMatch("conversionService", ConversionService.class)) {
            beanFactory.setConversionService((ConversionService)beanFactory.getBean("conversionService", ConversionService.class));
        }
        for (String weaverAwareName : weaverAwareNames = beanFactory.getBeanNamesForType(LoadTimeWeaverAware.class, false, false)) {
            this.getBean(weaverAwareName);
        }
        beanFactory.setTempClassLoader(null);
        beanFactory.freezeConfiguration();
        beanFactory.preInstantiateSingletons();
    }

    protected void finishRefresh() {
        this.initLifecycleProcessor();
        this.getLifecycleProcessor().onRefresh();
        this.publishEvent(new ContextRefreshedEvent(this));
        LiveBeansView.registerApplicationContext(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelRefresh(BeansException ex) {
        Object object = this.activeMonitor;
        synchronized (object) {
            this.active = false;
        }
    }

    @Override
    public void registerShutdownHook() {
        if (this.shutdownHook == null) {
            this.shutdownHook = new Thread(){

                @Override
                public void run() {
                    AbstractApplicationContext.this.doClose();
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    public void destroy() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            this.doClose();
            if (this.shutdownHook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() {
        boolean actuallyClose;
        Object object = this.activeMonitor;
        synchronized (object) {
            actuallyClose = this.active && !this.closed;
            this.closed = true;
        }
        if (actuallyClose) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Closing " + this));
            }
            LiveBeansView.unregisterApplicationContext(this);
            try {
                this.publishEvent(new ContextClosedEvent(this));
            }
            catch (Throwable ex) {
                this.logger.warn((Object)"Exception thrown from ApplicationListener handling ContextClosedEvent", ex);
            }
            try {
                this.getLifecycleProcessor().onClose();
            }
            catch (Throwable ex) {
                this.logger.warn((Object)"Exception thrown from LifecycleProcessor on context close", ex);
            }
            this.destroyBeans();
            this.closeBeanFactory();
            this.onClose();
            object = this.activeMonitor;
            synchronized (object) {
                this.active = false;
            }
        }
    }

    protected void destroyBeans() {
        this.getBeanFactory().destroySingletons();
    }

    protected void onClose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        Object object = this.activeMonitor;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertBeanFactoryActive() {
        Object object = this.activeMonitor;
        synchronized (object) {
            if (!this.active) {
                if (this.closed) {
                    throw new IllegalStateException(this.getDisplayName() + " has been closed already");
                }
                throw new IllegalStateException(this.getDisplayName() + " has not been refreshed yet");
            }
        }
    }

    public Object getBean(String name) throws BeansException {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBean(name);
    }

    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        this.assertBeanFactoryActive();
        return (T)this.getBeanFactory().getBean(name, requiredType);
    }

    public <T> T getBean(Class<T> requiredType) throws BeansException {
        this.assertBeanFactoryActive();
        return (T)this.getBeanFactory().getBean(requiredType);
    }

    public Object getBean(String name, Object ... args) throws BeansException {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBean(name, args);
    }

    public boolean containsBean(String name) {
        return this.getBeanFactory().containsBean(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().isSingleton(name);
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().isPrototype(name);
    }

    public boolean isTypeMatch(String name, Class<?> targetType) throws NoSuchBeanDefinitionException {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().isTypeMatch(name, targetType);
    }

    public Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getType(name);
    }

    public String[] getAliases(String name) {
        return this.getBeanFactory().getAliases(name);
    }

    public boolean containsBeanDefinition(String beanName) {
        return this.getBeanFactory().containsBeanDefinition(beanName);
    }

    public int getBeanDefinitionCount() {
        return this.getBeanFactory().getBeanDefinitionCount();
    }

    public String[] getBeanDefinitionNames() {
        return this.getBeanFactory().getBeanDefinitionNames();
    }

    public String[] getBeanNamesForType(Class<?> type) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeanNamesForType(type);
    }

    public String[] getBeanNamesForType(Class<?> type, boolean includeNonSingletons, boolean allowEagerInit) {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeanNamesForType(type, includeNonSingletons, allowEagerInit);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type) throws BeansException {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeansOfType(type);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeansOfType(type, includeNonSingletons, allowEagerInit);
    }

    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) throws BeansException {
        this.assertBeanFactoryActive();
        return this.getBeanFactory().getBeansWithAnnotation(annotationType);
    }

    public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType) {
        this.assertBeanFactoryActive();
        return (A)this.getBeanFactory().findAnnotationOnBean(beanName, annotationType);
    }

    public BeanFactory getParentBeanFactory() {
        return this.getParent();
    }

    public boolean containsLocalBean(String name) {
        return this.getBeanFactory().containsLocalBean(name);
    }

    protected BeanFactory getInternalParentBeanFactory() {
        return this.getParent() instanceof ConfigurableApplicationContext ? ((ConfigurableApplicationContext)this.getParent()).getBeanFactory() : this.getParent();
    }

    @Override
    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return this.getMessageSource().getMessage(code, args, defaultMessage, locale);
    }

    @Override
    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.getMessageSource().getMessage(code, args, locale);
    }

    @Override
    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        return this.getMessageSource().getMessage(resolvable, locale);
    }

    private MessageSource getMessageSource() throws IllegalStateException {
        if (this.messageSource == null) {
            throw new IllegalStateException("MessageSource not initialized - call 'refresh' before accessing messages via the context: " + this);
        }
        return this.messageSource;
    }

    protected MessageSource getInternalParentMessageSource() {
        return this.getParent() instanceof AbstractApplicationContext ? ((AbstractApplicationContext)this.getParent()).messageSource : this.getParent();
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        return this.resourcePatternResolver.getResources(locationPattern);
    }

    @Override
    public void start() {
        this.getLifecycleProcessor().start();
        this.publishEvent(new ContextStartedEvent(this));
    }

    @Override
    public void stop() {
        this.getLifecycleProcessor().stop();
        this.publishEvent(new ContextStoppedEvent(this));
    }

    @Override
    public boolean isRunning() {
        return this.getLifecycleProcessor().isRunning();
    }

    protected abstract void refreshBeanFactory() throws BeansException, IllegalStateException;

    protected abstract void closeBeanFactory();

    @Override
    public abstract ConfigurableListableBeanFactory getBeanFactory() throws IllegalStateException;

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getDisplayName());
        sb.append(": startup date [").append(new Date(this.getStartupDate()));
        sb.append("]; ");
        ApplicationContext parent = this.getParent();
        if (parent == null) {
            sb.append("root of context hierarchy");
        } else {
            sb.append("parent: ").append(parent.getDisplayName());
        }
        return sb.toString();
    }

    static {
        ContextClosedEvent.class.getName();
    }
}

