/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import java.lang.reflect.Method;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.method.MethodConstraintViolationException;
import org.hibernate.validator.method.MethodValidator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.annotation.Validated;

public class MethodValidationInterceptor
implements MethodInterceptor {
    private static Method forExecutablesMethod;
    private static Method validateParametersMethod;
    private static Method validateReturnValueMethod;
    private final Validator validator;

    public MethodValidationInterceptor() {
        this(forExecutablesMethod != null ? Validation.buildDefaultValidatorFactory() : HibernateValidatorDelegate.buildValidatorFactory());
    }

    public MethodValidationInterceptor(ValidatorFactory validatorFactory) {
        this(validatorFactory.getValidator());
    }

    public MethodValidationInterceptor(Validator validator) {
        this.validator = validator;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class[] groups = this.determineValidationGroups(invocation);
        if (forExecutablesMethod != null) {
            Object executableValidator = ReflectionUtils.invokeMethod((Method)forExecutablesMethod, (Object)this.validator);
            Set result = (Set)ReflectionUtils.invokeMethod((Method)validateParametersMethod, (Object)executableValidator, (Object[])new Object[]{invocation.getThis(), invocation.getMethod(), invocation.getArguments(), groups});
            if (!result.isEmpty()) {
                throw new ConstraintViolationException(result);
            }
            Object returnValue = invocation.proceed();
            result = (Set)ReflectionUtils.invokeMethod((Method)validateReturnValueMethod, (Object)executableValidator, (Object[])new Object[]{invocation.getThis(), invocation.getMethod(), returnValue, groups});
            if (!result.isEmpty()) {
                throw new ConstraintViolationException(result);
            }
            return returnValue;
        }
        return HibernateValidatorDelegate.invokeWithinValidation(invocation, this.validator, groups);
    }

    protected Class[] determineValidationGroups(MethodInvocation invocation) {
        Validated valid = (Validated)AnnotationUtils.findAnnotation(invocation.getThis().getClass(), Validated.class);
        return valid != null ? valid.value() : new Class[]{};
    }

    static {
        try {
            forExecutablesMethod = Validator.class.getMethod("forExecutables", new Class[0]);
            Class<?> executableValidatorClass = forExecutablesMethod.getReturnType();
            validateParametersMethod = executableValidatorClass.getMethod("validateParameters", Object.class, Method.class, Object[].class, Class[].class);
            validateReturnValueMethod = executableValidatorClass.getMethod("validateReturnValue", Object.class, Method.class, Object.class, Class[].class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class HibernateValidatorDelegate {
        private HibernateValidatorDelegate() {
        }

        public static ValidatorFactory buildValidatorFactory() {
            return ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).buildValidatorFactory();
        }

        public static Object invokeWithinValidation(MethodInvocation invocation, Validator validator, Class[] groups) throws Throwable {
            MethodValidator methodValidator = (MethodValidator)validator.unwrap(MethodValidator.class);
            Set result = methodValidator.validateAllParameters(invocation.getThis(), invocation.getMethod(), invocation.getArguments(), groups);
            if (!result.isEmpty()) {
                throw new MethodConstraintViolationException(result);
            }
            Object returnValue = invocation.proceed();
            result = methodValidator.validateReturnValue(invocation.getThis(), invocation.getMethod(), returnValue, groups);
            if (!result.isEmpty()) {
                throw new MethodConstraintViolationException(result);
            }
            return returnValue;
        }
    }
}

