/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.cache.annotation.CacheAnnotationParser;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.cache.interceptor.CacheEvictOperation;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CachePutOperation;
import org.springframework.cache.interceptor.CacheableOperation;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SpringCacheAnnotationParser
implements CacheAnnotationParser,
Serializable {
    @Override
    public Collection<CacheOperation> parseCacheAnnotations(Class<?> type) {
        DefaultCacheConfig defaultConfig = this.getDefaultCacheConfig(type);
        return this.parseCacheAnnotations(defaultConfig, type);
    }

    @Override
    public Collection<CacheOperation> parseCacheAnnotations(Method method) {
        DefaultCacheConfig defaultConfig = this.getDefaultCacheConfig(method.getDeclaringClass());
        return this.parseCacheAnnotations(defaultConfig, method);
    }

    protected Collection<CacheOperation> parseCacheAnnotations(DefaultCacheConfig cachingConfig, AnnotatedElement ae) {
        Collection<Caching> collection;
        Collection<CachePut> collection2;
        Collection<CacheEvict> evicts;
        Collection<CacheOperation> ops = null;
        Collection<Cacheable> cacheables = this.getAnnotations(ae, Cacheable.class);
        if (cacheables != null) {
            ops = this.lazyInit(ops);
            for (Cacheable cacheable : cacheables) {
                ops.add(this.parseCacheableAnnotation(ae, cachingConfig, cacheable));
            }
        }
        if ((evicts = this.getAnnotations(ae, CacheEvict.class)) != null) {
            ops = this.lazyInit(ops);
            for (CacheEvict cacheEvict : evicts) {
                ops.add(this.parseEvictAnnotation(ae, cachingConfig, cacheEvict));
            }
        }
        if ((collection2 = this.getAnnotations(ae, CachePut.class)) != null) {
            ops = this.lazyInit(ops);
            for (CachePut p : collection2) {
                ops.add(this.parseUpdateAnnotation(ae, cachingConfig, p));
            }
        }
        if ((collection = this.getAnnotations(ae, Caching.class)) != null) {
            ops = this.lazyInit(ops);
            for (Caching c : collection) {
                ops.addAll(this.parseCachingAnnotation(ae, cachingConfig, c));
            }
        }
        return ops;
    }

    private <T extends Annotation> Collection<CacheOperation> lazyInit(Collection<CacheOperation> ops) {
        return ops != null ? ops : new ArrayList(1);
    }

    CacheableOperation parseCacheableAnnotation(AnnotatedElement ae, DefaultCacheConfig defaultConfig, Cacheable caching) {
        CacheableOperation cuo = new CacheableOperation();
        cuo.setCacheNames(caching.value());
        cuo.setCondition(caching.condition());
        cuo.setUnless(caching.unless());
        cuo.setKey(caching.key());
        cuo.setKeyGenerator(caching.keyGenerator());
        cuo.setCacheManager(caching.cacheManager());
        cuo.setCacheResolver(caching.cacheResolver());
        cuo.setName(ae.toString());
        defaultConfig.applyDefault(cuo);
        this.validateCacheOperation(ae, cuo);
        return cuo;
    }

    CacheEvictOperation parseEvictAnnotation(AnnotatedElement ae, DefaultCacheConfig defaultConfig, CacheEvict caching) {
        CacheEvictOperation ceo = new CacheEvictOperation();
        ceo.setCacheNames(caching.value());
        ceo.setCondition(caching.condition());
        ceo.setKey(caching.key());
        ceo.setKeyGenerator(caching.keyGenerator());
        ceo.setCacheManager(caching.cacheManager());
        ceo.setCacheResolver(caching.cacheResolver());
        ceo.setCacheWide(caching.allEntries());
        ceo.setBeforeInvocation(caching.beforeInvocation());
        ceo.setName(ae.toString());
        defaultConfig.applyDefault(ceo);
        this.validateCacheOperation(ae, ceo);
        return ceo;
    }

    CacheOperation parseUpdateAnnotation(AnnotatedElement ae, DefaultCacheConfig defaultConfig, CachePut caching) {
        CachePutOperation cuo = new CachePutOperation();
        cuo.setCacheNames(caching.value());
        cuo.setCondition(caching.condition());
        cuo.setUnless(caching.unless());
        cuo.setKey(caching.key());
        cuo.setKeyGenerator(caching.keyGenerator());
        cuo.setCacheManager(caching.cacheManager());
        cuo.setCacheResolver(caching.cacheResolver());
        cuo.setName(ae.toString());
        defaultConfig.applyDefault(cuo);
        this.validateCacheOperation(ae, cuo);
        return cuo;
    }

    Collection<CacheOperation> parseCachingAnnotation(AnnotatedElement ae, DefaultCacheConfig defaultConfig, Caching caching) {
        Object[] updates;
        Object[] evicts;
        Collection<CacheOperation> ops = null;
        Object[] cacheables = caching.cacheable();
        if (!ObjectUtils.isEmpty((Object[])cacheables)) {
            ops = this.lazyInit(ops);
            for (Object cacheable : cacheables) {
                ops.add(this.parseCacheableAnnotation(ae, defaultConfig, (Cacheable)cacheable));
            }
        }
        if (!ObjectUtils.isEmpty((Object[])(evicts = caching.evict()))) {
            ops = this.lazyInit(ops);
            for (Object evict : evicts) {
                ops.add(this.parseEvictAnnotation(ae, defaultConfig, (CacheEvict)evict));
            }
        }
        if (!ObjectUtils.isEmpty((Object[])(updates = caching.put()))) {
            ops = this.lazyInit(ops);
            for (Object update : updates) {
                ops.add(this.parseUpdateAnnotation(ae, defaultConfig, (CachePut)update));
            }
        }
        return ops;
    }

    DefaultCacheConfig getDefaultCacheConfig(Class<?> target) {
        CacheConfig annotation = (CacheConfig)AnnotationUtils.getAnnotation(target, CacheConfig.class);
        if (annotation != null) {
            return new DefaultCacheConfig(annotation.cacheNames(), annotation.keyGenerator(), annotation.cacheManager(), annotation.cacheResolver());
        }
        return new DefaultCacheConfig();
    }

    private <T extends Annotation> Collection<T> getAnnotations(AnnotatedElement ae, Class<T> annotationType) {
        ArrayList<T> anns = new ArrayList<T>(2);
        T ann = ae.getAnnotation(annotationType);
        if (ann != null) {
            anns.add(ann);
        }
        for (Annotation metaAnn : ae.getAnnotations()) {
            ann = metaAnn.annotationType().getAnnotation(annotationType);
            if (ann == null) continue;
            anns.add(ann);
        }
        return anns.isEmpty() ? null : anns;
    }

    private void validateCacheOperation(AnnotatedElement ae, CacheOperation operation) {
        if (StringUtils.hasText((String)operation.getKey()) && StringUtils.hasText((String)operation.getKeyGenerator())) {
            throw new IllegalStateException("Invalid cache annotation configuration on '" + ae.toString() + "'. Both 'key' and 'keyGenerator' attributes have been set. " + "These attributes are mutually exclusive: either set the SpEL expression used to" + "compute the key at runtime or set the name of the KeyGenerator bean to use.");
        }
        if (StringUtils.hasText((String)operation.getCacheManager()) && StringUtils.hasText((String)operation.getCacheResolver())) {
            throw new IllegalStateException("Invalid cache annotation configuration on '" + ae.toString() + "'. Both 'cacheManager' and 'cacheResolver' attributes have been set. " + "These attributes are mutually exclusive: the cache manager is used to configure a" + "default cache resolver if none is set. If a cache resolver is set, the cache manager" + "won't be used.");
        }
        if (operation.getCacheNames().isEmpty()) {
            throw new IllegalStateException("No cache names could be detected on '" + ae.toString() + "'. Make sure to set the value parameter on the annotation or " + "declare a @CacheConfig at the class-level with the default cache name(s) to use.");
        }
    }

    public boolean equals(Object other) {
        return this == other || other instanceof SpringCacheAnnotationParser;
    }

    public int hashCode() {
        return SpringCacheAnnotationParser.class.hashCode();
    }

    static class DefaultCacheConfig {
        private final String[] cacheNames;
        private final String keyGenerator;
        private final String cacheManager;
        private final String cacheResolver;

        private DefaultCacheConfig(String[] cacheNames, String keyGenerator, String cacheManager, String cacheResolver) {
            this.cacheNames = cacheNames;
            this.keyGenerator = keyGenerator;
            this.cacheManager = cacheManager;
            this.cacheResolver = cacheResolver;
        }

        public DefaultCacheConfig() {
            this(null, null, null, null);
        }

        public void applyDefault(CacheOperation operation) {
            if (operation.getCacheNames().isEmpty() && this.cacheNames != null) {
                operation.setCacheNames(this.cacheNames);
            }
            if (!StringUtils.hasText((String)operation.getKey()) && !StringUtils.hasText((String)operation.getKeyGenerator()) && StringUtils.hasText((String)this.keyGenerator)) {
                operation.setKeyGenerator(this.keyGenerator);
            }
            if (!this.isSet(operation.getCacheManager()) && !this.isSet(operation.getCacheResolver())) {
                if (this.isSet(this.cacheResolver)) {
                    operation.setCacheResolver(this.cacheResolver);
                } else if (this.isSet(this.cacheManager)) {
                    operation.setCacheManager(this.cacheManager);
                }
            }
        }

        private boolean isSet(String s) {
            return StringUtils.hasText((String)s);
        }
    }
}

