/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import java.lang.reflect.Method;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.annotation.Validated;

public class MethodValidationInterceptor
implements MethodInterceptor {
    private static Method forExecutablesMethod;
    private static Method validateParametersMethod;
    private static Method validateReturnValueMethod;
    private final Validator validator;

    public MethodValidationInterceptor() {
        this(Validation.buildDefaultValidatorFactory());
    }

    public MethodValidationInterceptor(ValidatorFactory validatorFactory) {
        this(validatorFactory.getValidator());
    }

    public MethodValidationInterceptor(Validator validator) {
        this.validator = validator;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Set result;
        Class<?>[] groups = this.determineValidationGroups(invocation);
        Object execVal = ReflectionUtils.invokeMethod((Method)forExecutablesMethod, (Object)this.validator);
        Method methodToValidate = invocation.getMethod();
        try {
            result = (Set)ReflectionUtils.invokeMethod((Method)validateParametersMethod, (Object)execVal, (Object[])new Object[]{invocation.getThis(), methodToValidate, invocation.getArguments(), groups});
        }
        catch (IllegalArgumentException ex) {
            methodToValidate = BridgeMethodResolver.findBridgedMethod((Method)ClassUtils.getMostSpecificMethod((Method)invocation.getMethod(), invocation.getThis().getClass()));
            result = (Set)ReflectionUtils.invokeMethod((Method)validateParametersMethod, (Object)execVal, (Object[])new Object[]{invocation.getThis(), methodToValidate, invocation.getArguments(), groups});
        }
        if (!result.isEmpty()) {
            throw new ConstraintViolationException(result);
        }
        Object returnValue = invocation.proceed();
        result = (Set)ReflectionUtils.invokeMethod((Method)validateReturnValueMethod, (Object)execVal, (Object[])new Object[]{invocation.getThis(), methodToValidate, returnValue, groups});
        if (!result.isEmpty()) {
            throw new ConstraintViolationException(result);
        }
        return returnValue;
    }

    protected Class<?>[] determineValidationGroups(MethodInvocation invocation) {
        Validated validatedAnn = (Validated)AnnotationUtils.findAnnotation((Method)invocation.getMethod(), Validated.class);
        if (validatedAnn == null) {
            validatedAnn = (Validated)AnnotationUtils.findAnnotation(invocation.getThis().getClass(), Validated.class);
        }
        return validatedAnn != null ? validatedAnn.value() : new Class[]{};
    }

    static {
        try {
            forExecutablesMethod = Validator.class.getMethod("forExecutables", new Class[0]);
            Class<?> executableValidatorClass = forExecutablesMethod.getReturnType();
            validateParametersMethod = executableValidatorClass.getMethod("validateParameters", Object.class, Method.class, Object[].class, Class[].class);
            validateReturnValueMethod = executableValidatorClass.getMethod("validateReturnValue", Object.class, Method.class, Object.class, Class[].class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

