/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.agent;

import java.util.ArrayDeque;
import java.util.Deque;
import org.springframework.aot.agent.RecordedInvocation;
import org.springframework.aot.agent.RecordedInvocationsListener;

public abstract class RecordedInvocationsPublisher {
    private static final Deque<RecordedInvocationsListener> LISTENERS = new ArrayDeque<RecordedInvocationsListener>();

    private RecordedInvocationsPublisher() {
    }

    public static void addListener(RecordedInvocationsListener listener) {
        LISTENERS.addLast(listener);
    }

    public static void removeListener(RecordedInvocationsListener listener) {
        LISTENERS.remove(listener);
    }

    static void publish(RecordedInvocation invocation) {
        LISTENERS.forEach(listener -> listener.onInvocation(invocation));
    }
}

