/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.test.io.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.lang.Nullable;

public class MockSpringFactoriesLoader
extends SpringFactoriesLoader {
    private final AtomicInteger sequence = new AtomicInteger();
    private final Map<String, List<String>> factories;
    private final Map<String, Object> implementations = new HashMap<String, Object>();

    public MockSpringFactoriesLoader() {
        this(null);
    }

    public MockSpringFactoriesLoader(@Nullable ClassLoader classLoader) {
        this(classLoader, new LinkedHashMap<String, List<String>>());
    }

    protected MockSpringFactoriesLoader(@Nullable ClassLoader classLoader, Map<String, List<String>> factories) {
        super(classLoader, factories);
        this.factories = factories;
    }

    protected <T> T instantiateFactory(String implementationName, Class<T> type, @Nullable SpringFactoriesLoader.ArgumentResolver argumentResolver, SpringFactoriesLoader.FailureHandler failureHandler) {
        Object implementation;
        if (implementationName.startsWith("!") && (implementation = this.implementations.get(implementationName)) != null) {
            return (T)implementation;
        }
        return (T)super.instantiateFactory(implementationName, type, argumentResolver, failureHandler);
    }

    @SafeVarargs
    public final <T> void add(Class<T> factoryType, Class<? extends T> ... factoryImplementations) {
        for (Class<T> clazz : factoryImplementations) {
            this.add(factoryType.getName(), clazz.getName());
        }
    }

    public void add(String factoryType, String ... factoryImplementations) {
        List implementations = this.factories.computeIfAbsent(factoryType, key -> new ArrayList());
        Collections.addAll(implementations, factoryImplementations);
    }

    public <T> void addInstance(Class<T> factoryType, T ... factoryInstances) {
        this.addInstance(factoryType.getName(), factoryInstances);
    }

    public <T> void addInstance(String factoryType, T ... factoryInstance) {
        List implementations = this.factories.computeIfAbsent(factoryType, key -> new ArrayList());
        for (T factoryImplementation : factoryInstance) {
            String reference = "!" + factoryType + ":" + factoryImplementation.getClass().getName() + this.sequence.getAndIncrement();
            implementations.add(reference);
            this.implementations.put(reference, factoryImplementation);
        }
    }
}

