/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.test.tools;

import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.springframework.core.test.tools.DynamicFiles;
import org.springframework.core.test.tools.SourceFile;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public final class SourceFiles
implements Iterable<SourceFile> {
    private static final SourceFiles NONE = new SourceFiles(DynamicFiles.none());
    private final DynamicFiles<SourceFile> files;

    private SourceFiles(DynamicFiles<SourceFile> files) {
        this.files = files;
    }

    public static SourceFiles none() {
        return NONE;
    }

    public static SourceFiles of(SourceFile ... sourceFiles) {
        return SourceFiles.none().and(sourceFiles);
    }

    public SourceFiles and(SourceFile ... sourceFiles) {
        return new SourceFiles(this.files.and(sourceFiles));
    }

    public SourceFiles and(Iterable<SourceFile> sourceFiles) {
        return new SourceFiles(this.files.and(sourceFiles));
    }

    public SourceFiles and(SourceFiles sourceFiles) {
        return new SourceFiles(this.files.and(sourceFiles.files));
    }

    @Override
    public Iterator<SourceFile> iterator() {
        return this.files.iterator();
    }

    public Stream<SourceFile> stream() {
        return this.files.stream();
    }

    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    @Nullable
    public SourceFile get(String path) {
        return this.files.get(path);
    }

    public SourceFile getSingle() throws IllegalStateException {
        return this.files.getSingle();
    }

    public SourceFile getSingle(String pattern) throws IllegalStateException {
        return this.getSingle(Pattern.compile(pattern));
    }

    private SourceFile getSingle(Pattern pattern) {
        return this.files.getSingle((F candidate) -> pattern.matcher(candidate.getClassName()).matches());
    }

    public SourceFile getSingleFromPackage(String packageName) {
        return this.files.getSingle((F candidate) -> ClassUtils.getPackageName((String)candidate.getClassName()).equals(packageName));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof SourceFiles)) return false;
        SourceFiles that = (SourceFiles)other;
        if (!this.files.equals(that.files)) return false;
        return true;
    }

    public int hashCode() {
        return this.files.hashCode();
    }

    public String toString() {
        return this.files.toString();
    }
}

