/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.test.agent;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.springframework.aot.agent.RecordedInvocation;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.test.agent.RuntimeHintsInvocations;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;

public class RuntimeHintsInvocationsAssert
extends AbstractAssert<RuntimeHintsInvocationsAssert, RuntimeHintsInvocations> {
    private final List<Consumer<RuntimeHints>> configurers = new ArrayList<Consumer<RuntimeHints>>();

    RuntimeHintsInvocationsAssert(RuntimeHintsInvocations invocations) {
        super((Object)invocations, RuntimeHintsInvocationsAssert.class);
    }

    public RuntimeHintsInvocationsAssert withRegistrar(RuntimeHintsRegistrar registrar) {
        this.configurers.add(hints -> registrar.registerHints(hints, ((Object)((Object)this)).getClass().getClassLoader()));
        return this;
    }

    public RuntimeHintsInvocationsAssert withSpringFactoriesRegistrars(String location) {
        List registrars = SpringFactoriesLoader.forResourceLocation((String)location).load(RuntimeHintsRegistrar.class);
        this.configurers.add(hints -> registrars.forEach(registrar -> registrar.registerHints(hints, ((Object)((Object)this)).getClass().getClassLoader())));
        return this;
    }

    private void configureRuntimeHints(RuntimeHints hints) {
        this.configurers.forEach(configurer -> configurer.accept(hints));
    }

    public void match(RuntimeHints runtimeHints) {
        Assert.notNull((Object)runtimeHints, (String)"RuntimeHints must not be null");
        this.configureRuntimeHints(runtimeHints);
        List<RecordedInvocation> noMatchInvocations = ((RuntimeHintsInvocations)this.actual).recordedInvocations().filter(invocation -> !invocation.matches(runtimeHints)).toList();
        if (!noMatchInvocations.isEmpty()) {
            this.throwAssertionError(this.errorMessageForInvocation(noMatchInvocations.get(0)));
        }
    }

    public ListAssert<RecordedInvocation> notMatching(RuntimeHints runtimeHints) {
        Assert.notNull((Object)runtimeHints, (String)"RuntimeHints must not be null");
        this.configureRuntimeHints(runtimeHints);
        return ListAssert.assertThatStream(((RuntimeHintsInvocations)this.actual).recordedInvocations().filter(invocation -> !invocation.matches(runtimeHints)));
    }

    private ErrorMessageFactory errorMessageForInvocation(RecordedInvocation invocation) {
        Class clazz;
        if (invocation.isStatic()) {
            return new BasicErrorMessageFactory("%nMissing <%s> for invocation <%s>%nwith arguments %s.%nStacktrace:%n<%s>", new Object[]{invocation.getHintType().hintClassName(), invocation.getMethodReference(), invocation.getArguments(), this.formatStackTrace(invocation.getStackFrames())});
        }
        Object t = invocation.getInstance();
        Class instanceType = t instanceof Class ? (clazz = (Class)t) : invocation.getInstance().getClass();
        return new BasicErrorMessageFactory("%nMissing <%s> for invocation <%s> on type <%s> %nwith arguments %s.%nStacktrace:%n<%s>", new Object[]{invocation.getHintType().hintClassName(), invocation.getMethodReference(), instanceType, invocation.getArguments(), this.formatStackTrace(invocation.getStackFrames())});
    }

    private String formatStackTrace(Stream<StackWalker.StackFrame> stackTraceElements) {
        return stackTraceElements.map(f -> f.getClassName() + "#" + f.getMethodName() + ", Line " + f.getLineNumber()).collect(Collectors.joining(System.lineSeparator()));
    }

    public RuntimeHintsInvocationsAssert hasCount(long count) {
        this.isNotNull();
        long invocationsCount = ((RuntimeHintsInvocations)this.actual).recordedInvocations().count();
        if (invocationsCount != count) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nNumber of recorded invocations does not match, expected <%n> but got <%n>.", new Object[]{invocationsCount, count}));
        }
        return this;
    }
}

