/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.test.tools;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.springframework.core.test.tools.WritableContent;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class DynamicFile {
    private final String path;
    private final String content;

    protected DynamicFile(String path, String content) {
        Assert.hasText((String)path, (String)"'path' must not be empty");
        Assert.hasText((String)content, (String)"'content' must not be empty");
        this.path = path;
        this.content = content;
    }

    protected static String toString(WritableContent writableContent) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            writableContent.writeTo(stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to read content", ex);
        }
    }

    public byte[] getBytes() {
        return this.content.getBytes(StandardCharsets.UTF_8);
    }

    public String getContent() {
        return this.content;
    }

    public String getPath() {
        return this.path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof DynamicFile)) return false;
        DynamicFile that = (DynamicFile)other;
        if (!this.path.equals(that.path)) return false;
        if (!this.content.equals(that.content)) return false;
        return true;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path;
    }
}

