/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.test.tools;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.springframework.core.test.tools.ClassFile;
import org.springframework.core.test.tools.ClassFiles;
import org.springframework.core.test.tools.CompilationException;
import org.springframework.core.test.tools.Compiled;
import org.springframework.core.test.tools.DynamicClassLoader;
import org.springframework.core.test.tools.DynamicJavaFileManager;
import org.springframework.core.test.tools.DynamicJavaFileObject;
import org.springframework.core.test.tools.ResourceFile;
import org.springframework.core.test.tools.ResourceFiles;
import org.springframework.core.test.tools.SourceFile;
import org.springframework.core.test.tools.SourceFiles;
import org.springframework.core.test.tools.WritableContent;
import org.springframework.lang.Nullable;

public final class TestCompiler {
    @Nullable
    private final ClassLoader classLoader;
    private final JavaCompiler compiler;
    private final SourceFiles sourceFiles;
    private final ResourceFiles resourceFiles;
    private final ClassFiles classFiles;
    private final List<Processor> processors;
    private final List<String> compilerOptions;

    private TestCompiler(@Nullable ClassLoader classLoader, JavaCompiler compiler, SourceFiles sourceFiles, ResourceFiles resourceFiles, ClassFiles classFiles, List<Processor> processors, List<String> compilerOptions) {
        this.classLoader = classLoader;
        this.compiler = compiler;
        this.sourceFiles = sourceFiles;
        this.resourceFiles = resourceFiles;
        this.classFiles = classFiles;
        this.processors = processors;
        this.compilerOptions = compilerOptions;
    }

    public static TestCompiler forSystem() {
        return TestCompiler.forCompiler(ToolProvider.getSystemJavaCompiler());
    }

    public static TestCompiler forCompiler(JavaCompiler javaCompiler) {
        return new TestCompiler(null, javaCompiler, SourceFiles.none(), ResourceFiles.none(), ClassFiles.none(), Collections.emptyList(), Collections.emptyList());
    }

    public TestCompiler with(UnaryOperator<TestCompiler> customizer) {
        return (TestCompiler)customizer.apply(this);
    }

    public TestCompiler withSources(SourceFile ... sourceFiles) {
        return new TestCompiler(this.classLoader, this.compiler, this.sourceFiles.and(sourceFiles), this.resourceFiles, this.classFiles, this.processors, this.compilerOptions);
    }

    public TestCompiler withSources(Iterable<SourceFile> sourceFiles) {
        return new TestCompiler(this.classLoader, this.compiler, this.sourceFiles.and(sourceFiles), this.resourceFiles, this.classFiles, this.processors, this.compilerOptions);
    }

    public TestCompiler withSources(SourceFiles sourceFiles) {
        return new TestCompiler(this.classLoader, this.compiler, this.sourceFiles.and(sourceFiles), this.resourceFiles, this.classFiles, this.processors, this.compilerOptions);
    }

    public TestCompiler withResources(ResourceFile ... resourceFiles) {
        return new TestCompiler(this.classLoader, this.compiler, this.sourceFiles, this.resourceFiles.and(resourceFiles), this.classFiles, this.processors, this.compilerOptions);
    }

    public TestCompiler withResources(Iterable<ResourceFile> resourceFiles) {
        return new TestCompiler(this.classLoader, this.compiler, this.sourceFiles, this.resourceFiles.and(resourceFiles), this.classFiles, this.processors, this.compilerOptions);
    }

    public TestCompiler withResources(ResourceFiles resourceFiles) {
        return new TestCompiler(this.classLoader, this.compiler, this.sourceFiles, this.resourceFiles.and(resourceFiles), this.classFiles, this.processors, this.compilerOptions);
    }

    public TestCompiler withClasses(Iterable<ClassFile> classFiles) {
        return new TestCompiler(this.classLoader, this.compiler, this.sourceFiles, this.resourceFiles, this.classFiles.and(classFiles), this.processors, this.compilerOptions);
    }

    public TestCompiler withProcessors(Processor ... processors) {
        ArrayList<Processor> mergedProcessors = new ArrayList<Processor>(this.processors);
        mergedProcessors.addAll(Arrays.asList(processors));
        return new TestCompiler(this.classLoader, this.compiler, this.sourceFiles, this.resourceFiles, this.classFiles, mergedProcessors, this.compilerOptions);
    }

    public TestCompiler withProcessors(Iterable<Processor> processors) {
        ArrayList<Processor> mergedProcessors = new ArrayList<Processor>(this.processors);
        processors.forEach(mergedProcessors::add);
        return new TestCompiler(this.classLoader, this.compiler, this.sourceFiles, this.resourceFiles, this.classFiles, mergedProcessors, this.compilerOptions);
    }

    public TestCompiler withCompilerOptions(String ... options) {
        List<String> mergedCompilerOptions = Stream.concat(this.compilerOptions.stream(), Arrays.stream(options)).distinct().toList();
        return new TestCompiler(this.classLoader, this.compiler, this.sourceFiles, this.resourceFiles, this.classFiles, this.processors, mergedCompilerOptions);
    }

    public TestCompiler failOnWarning() {
        return this.withCompilerOptions("-Xlint:all", "-Werror");
    }

    public void compile(WritableContent content, Consumer<Compiled> compiled) {
        this.compile(SourceFile.of(content), compiled);
    }

    public void compile(SourceFile sourceFile, Consumer<Compiled> compiled) {
        this.withSources(sourceFile).compile(compiled);
    }

    public void compile(SourceFiles sourceFiles, Consumer<Compiled> compiled) {
        this.withSources(sourceFiles).compile(compiled);
    }

    public void compile(SourceFiles sourceFiles, ResourceFiles resourceFiles, Consumer<Compiled> compiled) {
        this.withSources(sourceFiles).withResources(resourceFiles).compile(compiled);
    }

    public void compile(Consumer<Compiled> compiled) throws CompilationException {
        DynamicClassLoader dynamicClassLoader = this.compile();
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(dynamicClassLoader);
            compiled.accept(new Compiled(dynamicClassLoader, this.sourceFiles, this.resourceFiles));
        }
        catch (IllegalAccessError ex) {
            throw new IllegalAccessError(ex.getMessage() + ". For non-public access ensure you annotate your test class or test method with @CompileWithForkedClassLoader");
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousClassLoader);
        }
    }

    private DynamicClassLoader compile() {
        ClassLoader classLoaderToUse = this.classLoader != null ? this.classLoader : Thread.currentThread().getContextClassLoader();
        List<DynamicJavaFileObject> compilationUnits = this.sourceFiles.stream().map(DynamicJavaFileObject::new).toList();
        StandardJavaFileManager standardFileManager = this.compiler.getStandardFileManager(null, null, null);
        DynamicJavaFileManager fileManager = new DynamicJavaFileManager(standardFileManager, classLoaderToUse, this.classFiles, this.resourceFiles);
        if (!this.sourceFiles.isEmpty()) {
            boolean result;
            Errors errors = new Errors();
            JavaCompiler.CompilationTask task = this.compiler.getTask(null, fileManager, errors, this.compilerOptions, null, compilationUnits);
            if (!this.processors.isEmpty()) {
                task.setProcessors(this.processors);
            }
            if (!(result = task.call().booleanValue()) || errors.hasReportedErrors()) {
                throw new CompilationException(errors.toString(), this.sourceFiles, this.resourceFiles);
            }
        }
        return new DynamicClassLoader(classLoaderToUse, this.classFiles, this.resourceFiles, fileManager.getDynamicClassFiles(), fileManager.getDynamicResourceFiles());
    }

    public TestCompiler printFiles(PrintStream printStream) {
        for (SourceFile sourceFile : this.sourceFiles) {
            printStream.append("---- source:   ").append(sourceFile.getPath()).append("\n\n");
            printStream.append(sourceFile.getContent());
            printStream.append("\n\n");
        }
        for (ResourceFile resourceFile : this.resourceFiles) {
            printStream.append("---- resource: ").append(resourceFile.getPath()).append("\n\n");
            printStream.append(resourceFile.getContent());
            printStream.append("\n\n");
        }
        return this;
    }

    static class Errors
    implements DiagnosticListener<JavaFileObject> {
        private final StringBuilder message = new StringBuilder();

        Errors() {
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                this.message.append('\n');
                this.message.append(diagnostic.getMessage(Locale.getDefault()));
                if (diagnostic.getSource() != null) {
                    this.message.append(' ');
                    this.message.append(diagnostic.getSource().getName());
                    this.message.append(' ');
                    this.message.append(diagnostic.getLineNumber()).append(':').append(diagnostic.getColumnNumber());
                }
            }
        }

        boolean hasReportedErrors() {
            return !this.message.isEmpty();
        }

        public String toString() {
            return this.message.toString();
        }
    }
}

