/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.test.tools;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.AssertProvider;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.test.tools.DynamicFile;
import org.springframework.core.test.tools.SourceFileAssert;
import org.springframework.core.test.tools.WritableContent;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public final class SourceFile
extends DynamicFile
implements AssertProvider<SourceFileAssert> {
    private static final File TEST_SOURCE_DIRECTORY = new File("src/test/java");
    private final String className;

    private SourceFile(String path, String content, String className) {
        super(path, content);
        this.className = className;
    }

    public static SourceFile forTestClass(Class<?> type) {
        return SourceFile.forClass(TEST_SOURCE_DIRECTORY, type);
    }

    public static SourceFile forClass(File sourceDirectory, Class<?> type) {
        String sourceFileName = type.getName().replace('.', '/');
        File sourceFile = new File(sourceDirectory, sourceFileName + ".java");
        return SourceFile.of(() -> new FileInputStream(sourceFile));
    }

    public static SourceFile of(CharSequence charSequence) {
        return SourceFile.of(null, charSequence);
    }

    public static SourceFile of(@Nullable String path, CharSequence charSequence) {
        return SourceFile.of(path, (Appendable appendable) -> appendable.append(charSequence));
    }

    public static SourceFile of(InputStreamSource inputStreamSource) {
        return SourceFile.of(null, inputStreamSource);
    }

    public static SourceFile of(@Nullable String path, InputStreamSource inputStreamSource) {
        return SourceFile.of(path, (Appendable appendable) -> appendable.append(SourceFile.copyToString(inputStreamSource)));
    }

    private static String copyToString(InputStreamSource inputStreamSource) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStreamSource.getInputStream(), StandardCharsets.UTF_8);
        return FileCopyUtils.copyToString((Reader)reader);
    }

    public static SourceFile of(WritableContent writableContent) {
        return SourceFile.of(null, writableContent);
    }

    public static SourceFile of(@Nullable String path, WritableContent writableContent) {
        String content = SourceFile.toString(writableContent);
        Assert.state((boolean)StringUtils.hasLength((String)content), (String)"WritableContent did not append any content");
        String className = SourceFile.getClassName(content);
        if (!StringUtils.hasLength((String)path)) {
            path = ClassUtils.convertClassNameToResourcePath((String)className) + ".java";
        }
        return new SourceFile((String)path, content, className);
    }

    public String getClassName() {
        return this.className;
    }

    private static String getClassName(String content) {
        JavaProjectBuilder builder = new JavaProjectBuilder();
        try {
            JavaSource javaSource = builder.addSource((Reader)new StringReader(content));
            if (javaSource.getClasses().isEmpty()) {
                javaSource = builder.addSource((Reader)new StringReader(SourceFile.makeRecordsLookLikeClasses(content)));
            }
            Assert.state((javaSource.getClasses().size() == 1 ? 1 : 0) != 0, (String)"Source must define a single class");
            JavaClass javaClass = (JavaClass)javaSource.getClasses().get(0);
            return javaSource.getPackage() != null ? javaSource.getPackageName() + "." + javaClass.getName() : javaClass.getName();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to parse source file content:\n\n" + content, ex);
        }
    }

    private static String makeRecordsLookLikeClasses(String content) {
        Pattern pattern = Pattern.compile("record\\s(\\S+)\\(");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            StringBuilder result = new StringBuilder();
            result.append(content.substring(0, matcher.start()) + "class");
            result.append(content.substring(matcher.start() + 6, matcher.end() - 1));
            int parenthesesCount = 1;
            for (int i = matcher.end(); i < content.length(); ++i) {
                char ch = content.charAt(i);
                if (parenthesesCount > 0) {
                    if (ch == '(') {
                        ++parenthesesCount;
                        continue;
                    }
                    if (ch != ')') continue;
                    --parenthesesCount;
                    continue;
                }
                result.append(ch);
            }
            return SourceFile.makeRecordsLookLikeClasses(result.toString());
        }
        return content;
    }

    public SourceFileAssert assertThat() {
        return new SourceFileAssert(this);
    }
}

