/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.test.tools;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.InputStreamSource;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public final class ClassFile {
    private static final String CLASS_SUFFIX = ".class";
    private final String name;
    private final byte[] content;

    private ClassFile(String name, byte[] content) {
        this.name = name;
        this.content = content;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getContent() {
        return this.content;
    }

    public static ClassFile of(String name, byte[] content) {
        return new ClassFile(name, content);
    }

    public static ClassFile of(String name, InputStreamSource inputStreamSource) {
        return ClassFile.of(name, ClassFile.toBytes(inputStreamSource));
    }

    public static String toClassName(String path) {
        Assert.hasText((String)path, (String)"'path' must not be empty");
        if (!path.endsWith(CLASS_SUFFIX)) {
            throw new IllegalArgumentException("Path '" + path + "' must end with '.class'");
        }
        String name = path.replace('/', '.');
        return name.substring(0, name.length() - CLASS_SUFFIX.length());
    }

    private static byte[] toBytes(InputStreamSource inputStreamSource) {
        try {
            return FileCopyUtils.copyToByteArray((InputStream)inputStreamSource.getInputStream());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to read content", ex);
        }
    }
}

