/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.test.tools;

import java.util.Iterator;
import java.util.stream.Stream;
import org.springframework.core.test.tools.DynamicFiles;
import org.springframework.core.test.tools.ResourceFile;
import org.springframework.lang.Nullable;

public final class ResourceFiles
implements Iterable<ResourceFile> {
    private static final ResourceFiles NONE = new ResourceFiles(DynamicFiles.none());
    private final DynamicFiles<ResourceFile> files;

    private ResourceFiles(DynamicFiles<ResourceFile> files) {
        this.files = files;
    }

    public static ResourceFiles none() {
        return NONE;
    }

    public static ResourceFiles of(ResourceFile ... ResourceFiles2) {
        return ResourceFiles.none().and(ResourceFiles2);
    }

    public ResourceFiles and(ResourceFile ... resourceFiles) {
        return new ResourceFiles(this.files.and(resourceFiles));
    }

    public ResourceFiles and(Iterable<ResourceFile> resourceFiles) {
        return new ResourceFiles(this.files.and(resourceFiles));
    }

    public ResourceFiles and(ResourceFiles resourceFiles) {
        return new ResourceFiles(this.files.and(resourceFiles.files));
    }

    @Override
    public Iterator<ResourceFile> iterator() {
        return this.files.iterator();
    }

    public Stream<ResourceFile> stream() {
        return this.files.stream();
    }

    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    @Nullable
    public ResourceFile get(String path) {
        return this.files.get(path);
    }

    public ResourceFile getSingle() throws IllegalStateException {
        return this.files.getSingle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof ResourceFiles)) return false;
        ResourceFiles that = (ResourceFiles)other;
        if (!this.files.equals(that.files)) return false;
        return true;
    }

    public int hashCode() {
        return this.files.hashCode();
    }

    public String toString() {
        return this.files.toString();
    }
}

