/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.test.agent;

import java.util.ArrayDeque;
import java.util.Deque;
import org.springframework.aot.agent.RecordedInvocation;
import org.springframework.aot.agent.RecordedInvocationsListener;
import org.springframework.aot.agent.RecordedInvocationsPublisher;
import org.springframework.aot.agent.RuntimeHintsAgent;
import org.springframework.aot.test.agent.RuntimeHintsInvocations;
import org.springframework.util.Assert;

public final class RuntimeHintsRecorder {
    private final RuntimeHintsInvocationsListener listener = new RuntimeHintsInvocationsListener();

    private RuntimeHintsRecorder() {
    }

    public static synchronized RuntimeHintsInvocations record(Runnable action) {
        Assert.notNull((Object)action, (String)"Runnable action must not be null");
        Assert.state((boolean)RuntimeHintsAgent.isLoaded(), (String)"RuntimeHintsAgent must be loaded in the current JVM");
        RuntimeHintsRecorder recorder = new RuntimeHintsRecorder();
        RecordedInvocationsPublisher.addListener(recorder.listener);
        try {
            action.run();
        }
        finally {
            RecordedInvocationsPublisher.removeListener(recorder.listener);
        }
        return new RuntimeHintsInvocations(recorder.listener.recordedInvocations.stream().toList());
    }

    private static final class RuntimeHintsInvocationsListener
    implements RecordedInvocationsListener {
        private final Deque<RecordedInvocation> recordedInvocations = new ArrayDeque<RecordedInvocation>();

        private RuntimeHintsInvocationsListener() {
        }

        @Override
        public void onInvocation(RecordedInvocation invocation) {
            this.recordedInvocations.addLast(invocation);
        }
    }
}

