/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.test.tools;

import org.springframework.core.test.tools.ResourceFile;
import org.springframework.core.test.tools.ResourceFiles;
import org.springframework.core.test.tools.SourceFile;
import org.springframework.core.test.tools.SourceFiles;

public class CompilationException
extends RuntimeException {
    CompilationException(String errors, SourceFiles sourceFiles, ResourceFiles resourceFiles) {
        super(CompilationException.buildMessage(errors, sourceFiles, resourceFiles));
    }

    private static String buildMessage(String errors, SourceFiles sourceFiles, ResourceFiles resourceFiles) {
        StringBuilder message = new StringBuilder();
        message.append("Unable to compile source\n\n");
        message.append(errors);
        message.append("\n\n");
        for (SourceFile sourceFile : sourceFiles) {
            message.append("---- source:   ").append(sourceFile.getPath()).append("\n\n");
            message.append(sourceFile.getContent());
            message.append("\n\n");
        }
        for (ResourceFile resourceFile : resourceFiles) {
            message.append("---- resource: ").append(resourceFile.getPath()).append("\n\n");
            message.append(resourceFile.getContent());
            message.append("\n\n");
        }
        return message.toString();
    }
}

