/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.agent;

import java.util.Objects;
import org.springframework.lang.Nullable;

public final class MethodReference {
    private final String className;
    private final String methodName;

    private MethodReference(String className, String methodName) {
        this.className = className;
        this.methodName = methodName;
    }

    public static MethodReference of(Class<?> klass, String methodName) {
        return new MethodReference(klass.getCanonicalName(), methodName);
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodReference that = (MethodReference)o;
        return this.className.equals(that.className) && this.methodName.equals(that.methodName);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.methodName);
    }

    public String toString() {
        return this.className + "#" + this.methodName;
    }
}

