/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.agent;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.aot.agent.HintType;
import org.springframework.aot.agent.InstrumentedMethod;
import org.springframework.aot.agent.MethodReference;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class RecordedInvocation {
    @Nullable
    private final Object instance;
    private final InstrumentedMethod instrumentedMethod;
    private final Object[] arguments;
    @Nullable
    private final Object returnValue;
    private final List<StackWalker.StackFrame> stackFrames;

    private RecordedInvocation(InstrumentedMethod instrumentedMethod, @Nullable Object instance, Object[] arguments, @Nullable Object returnValue, List<StackWalker.StackFrame> stackFrames) {
        this.instance = instance;
        this.instrumentedMethod = instrumentedMethod;
        this.arguments = arguments;
        this.returnValue = returnValue;
        this.stackFrames = stackFrames;
    }

    public static Builder of(InstrumentedMethod instrumentedMethod) {
        Assert.notNull((Object)((Object)instrumentedMethod), (String)"InstrumentedMethod must not be null");
        return new Builder(instrumentedMethod);
    }

    public HintType getHintType() {
        return this.instrumentedMethod.getHintType();
    }

    public MethodReference getMethodReference() {
        return this.instrumentedMethod.methodReference();
    }

    public Stream<StackWalker.StackFrame> getStackFrames() {
        return this.stackFrames.stream();
    }

    public <T> T getInstance() {
        Assert.state((this.instance != null ? 1 : 0) != 0, (String)"Cannot resolve 'this' for static invocations");
        return (T)this.instance;
    }

    public TypeReference getInstanceTypeReference() {
        Assert.state((this.instance != null ? 1 : 0) != 0, (String)"Cannot resolve 'this' for static invocations");
        return TypeReference.of(this.instance.getClass());
    }

    public boolean isStatic() {
        return this.instance == null;
    }

    public List<Object> getArguments() {
        return Arrays.asList(this.arguments);
    }

    public <T> T getArgument(int index) {
        return (T)this.arguments[index];
    }

    public List<TypeReference> getArgumentTypes() {
        return this.getArgumentTypes(0);
    }

    public List<TypeReference> getArgumentTypes(int index) {
        return Arrays.stream(this.arguments).skip(index).map(param -> TypeReference.of(param.getClass())).toList();
    }

    @Nullable
    public <T> T getReturnValue() {
        return (T)this.returnValue;
    }

    public boolean matches(RuntimeHints hints) {
        return this.instrumentedMethod.matcher(this).test(hints);
    }

    public String toString() {
        Class clazz;
        if (this.isStatic()) {
            return "<%s> invocation of <%s> with arguments %s".formatted(this.getHintType().hintClassName(), this.getMethodReference(), this.getArguments());
        }
        Object t = this.getInstance();
        Class instanceType = t instanceof Class ? (clazz = (Class)t) : this.getInstance().getClass();
        return "<%s> invocation of <%s> on type <%s> with arguments %s".formatted(this.getHintType().hintClassName(), this.getMethodReference(), instanceType.getCanonicalName(), this.getArguments());
    }

    public static class Builder {
        @Nullable
        private Object instance;
        private final InstrumentedMethod instrumentedMethod;
        private Object[] arguments = new Object[0];
        @Nullable
        private Object returnValue;

        Builder(InstrumentedMethod instrumentedMethod) {
            this.instrumentedMethod = instrumentedMethod;
        }

        public Builder onInstance(Object instance) {
            this.instance = instance;
            return this;
        }

        public Builder withArgument(@Nullable Object argument) {
            if (argument != null) {
                this.arguments = new Object[]{argument};
            }
            return this;
        }

        public Builder withArguments(Object ... arguments) {
            if (arguments != null) {
                this.arguments = arguments;
            }
            return this;
        }

        public Builder returnValue(@Nullable Object returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        public RecordedInvocation build() {
            List stackFrames = StackWalker.getInstance().walk(stream -> stream.dropWhile(stackFrame -> stackFrame.getClassName().startsWith(this.getClass().getPackageName())).toList());
            return new RecordedInvocation(this.instrumentedMethod, this.instance, this.arguments, this.returnValue, stackFrames);
        }
    }
}

