/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.agent;

import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.List;
import org.springframework.aot.agent.InvocationsRecorderClassTransformer;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public final class RuntimeHintsAgent {
    private static boolean loaded = false;

    private RuntimeHintsAgent() {
    }

    public static void premain(@Nullable String agentArgs, Instrumentation inst) {
        loaded = true;
        ParsedArguments arguments = ParsedArguments.parse(agentArgs);
        InvocationsRecorderClassTransformer transformer = new InvocationsRecorderClassTransformer(arguments.getInstrumentedPackages(), arguments.getIgnoredPackages());
        inst.addTransformer(transformer);
    }

    public static boolean isLoaded() {
        return loaded;
    }

    private static final class ParsedArguments {
        List<String> instrumentedPackages;
        List<String> ignoredPackages;

        private ParsedArguments(List<String> instrumentedPackages, List<String> ignoredPackages) {
            this.instrumentedPackages = instrumentedPackages;
            this.ignoredPackages = ignoredPackages;
        }

        public String[] getInstrumentedPackages() {
            return this.instrumentedPackages.toArray(new String[0]);
        }

        public String[] getIgnoredPackages() {
            return this.ignoredPackages.toArray(new String[0]);
        }

        static ParsedArguments parse(@Nullable String agentArgs) {
            ArrayList<String> included = new ArrayList<String>();
            ArrayList<String> excluded = new ArrayList<String>();
            if (StringUtils.hasText((String)agentArgs)) {
                for (String argument : agentArgs.split(",")) {
                    if (argument.startsWith("+")) {
                        included.add(argument.substring(1));
                        continue;
                    }
                    if (argument.startsWith("-")) {
                        excluded.add(argument.substring(1));
                        continue;
                    }
                    throw new IllegalArgumentException("Cannot parse agent arguments [" + agentArgs + "]");
                }
            } else {
                included.add("org.springframework");
            }
            return new ParsedArguments(included, excluded);
        }
    }
}

