/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.test.generate;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.springframework.aot.generate.GeneratedFiles;
import org.springframework.aot.generate.InMemoryGeneratedFiles;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.test.tools.ClassFile;
import org.springframework.core.test.tools.ResourceFile;
import org.springframework.core.test.tools.SourceFile;
import org.springframework.core.test.tools.TestCompiler;

public final class CompilerFiles
implements UnaryOperator<TestCompiler> {
    private final InMemoryGeneratedFiles generatedFiles;

    private CompilerFiles(InMemoryGeneratedFiles generatedFiles) {
        this.generatedFiles = generatedFiles;
    }

    public static UnaryOperator<TestCompiler> from(InMemoryGeneratedFiles generatedFiles) {
        return new CompilerFiles(generatedFiles);
    }

    @Override
    public TestCompiler apply(TestCompiler testCompiler) {
        return testCompiler.withSources(this.adapt(GeneratedFiles.Kind.SOURCE, (path, inputStreamSource) -> SourceFile.of(inputStreamSource))).withResources(this.adapt(GeneratedFiles.Kind.RESOURCE, ResourceFile::of)).withClasses(this.adapt(GeneratedFiles.Kind.CLASS, (path, inputStreamSource) -> ClassFile.of(ClassFile.toClassName(path), inputStreamSource)));
    }

    private <T> List<T> adapt(GeneratedFiles.Kind kind, BiFunction<String, InputStreamSource, T> adapter) {
        ArrayList result = new ArrayList();
        this.generatedFiles.getGeneratedFiles(kind).forEach((k, v) -> result.add(adapter.apply((String)k, (InputStreamSource)v)));
        return result;
    }
}

