/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.test.tools;

import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.springframework.core.test.tools.CompileWithForkedClassLoaderClassLoader;

class CompileWithForkedClassLoaderExtension
implements InvocationInterceptor {
    CompileWithForkedClassLoaderExtension() {
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.intercept(invocation, extensionContext);
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.intercept(invocation, extensionContext);
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.intercept(invocation, extensionContext);
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.intercept(invocation, extensionContext);
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.intercept(invocation, extensionContext, () -> this.runTestWithModifiedClassPath(invocationContext, extensionContext));
    }

    private void intercept(InvocationInterceptor.Invocation<Void> invocation, ExtensionContext extensionContext) throws Throwable {
        this.intercept(invocation, extensionContext, Action.NONE);
    }

    private void intercept(InvocationInterceptor.Invocation<Void> invocation, ExtensionContext extensionContext, Action action) throws Throwable {
        if (this.isUsingForkedClassPathLoader(extensionContext)) {
            invocation.proceed();
            return;
        }
        invocation.skip();
        action.run();
    }

    private boolean isUsingForkedClassPathLoader(ExtensionContext extensionContext) {
        Class testClass = extensionContext.getRequiredTestClass();
        ClassLoader classLoader = testClass.getClassLoader();
        return classLoader.getClass().getName().equals(CompileWithForkedClassLoaderClassLoader.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestWithModifiedClassPath(ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        Class testClass = extensionContext.getRequiredTestClass();
        Method testMethod = (Method)invocationContext.getExecutable();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        CompileWithForkedClassLoaderClassLoader forkedClassPathClassLoader = new CompileWithForkedClassLoaderClassLoader(testClass.getClassLoader());
        Thread.currentThread().setContextClassLoader(forkedClassPathClassLoader);
        try {
            this.runTest(testClass, testMethod);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private void runTest(Class<?> testClass, Method testMethod) throws Throwable {
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectMethod((String)ReflectionUtils.getFullyQualifiedMethodName(testClass, (Method)testMethod))}).filters(new Filter[]{EngineFilter.includeEngines((String[])new String[]{"junit-jupiter"})}).build();
        SummaryGeneratingListener listener = new SummaryGeneratingListener();
        Launcher launcher = LauncherFactory.create();
        launcher.execute(request, new TestExecutionListener[]{listener});
        TestExecutionSummary summary = listener.getSummary();
        if (summary.getTotalFailureCount() > 0L) {
            throw ((TestExecutionSummary.Failure)summary.getFailures().get(0)).getException();
        }
    }

    @FunctionalInterface
    static interface Action {
        public static final Action NONE = () -> {};

        public void run() throws Throwable;
    }
}

