/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.test.tools;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.core.test.tools.ResourceFile;
import org.springframework.core.test.tools.ResourceFiles;
import org.springframework.core.test.tools.SourceFile;
import org.springframework.core.test.tools.SourceFiles;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Compiled {
    private final ClassLoader classLoader;
    private final SourceFiles sourceFiles;
    private final ResourceFiles resourceFiles;
    @Nullable
    private List<Class<?>> compiledClasses;

    Compiled(ClassLoader classLoader, SourceFiles sourceFiles, ResourceFiles resourceFiles) {
        this.classLoader = classLoader;
        this.sourceFiles = sourceFiles;
        this.resourceFiles = resourceFiles;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public SourceFile getSourceFile() {
        return this.sourceFiles.getSingle();
    }

    public SourceFile getSourceFile(String pattern) {
        return this.sourceFiles.getSingle(pattern);
    }

    public SourceFile getSourceFileFromPackage(String packageName) {
        return this.sourceFiles.getSingleFromPackage(packageName);
    }

    public SourceFiles getSourceFiles() {
        return this.sourceFiles;
    }

    public ResourceFile getResourceFile() {
        return this.resourceFiles.getSingle();
    }

    public ResourceFiles getResourceFiles() {
        return this.resourceFiles;
    }

    public <T> T getInstance(Class<T> type) {
        List<Class> matching = this.getAllCompiledClasses().stream().filter(type::isAssignableFrom).toList();
        Assert.state((!matching.isEmpty() ? 1 : 0) != 0, () -> "No instance found of type " + type.getName());
        Assert.state((matching.size() == 1 ? 1 : 0) != 0, () -> "Multiple instances found of type " + type.getName());
        return type.cast(this.newInstance(matching.get(0)));
    }

    public <T> T getInstance(Class<T> type, String className) {
        Class<?> loaded = this.loadClass(className);
        return type.cast(this.newInstance(loaded));
    }

    public List<Class<?>> getAllCompiledClasses() {
        List<Class<?>> compiledClasses = this.compiledClasses;
        if (compiledClasses == null) {
            compiledClasses = new ArrayList();
            this.sourceFiles.stream().map(this::loadClass).forEach(compiledClasses::add);
            this.compiledClasses = Collections.unmodifiableList(compiledClasses);
        }
        return compiledClasses;
    }

    private Object newInstance(Class<?> loaded) {
        try {
            Constructor<?> constructor = loaded.getDeclaredConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Class<?> loadClass(SourceFile sourceFile) {
        return this.loadClass(sourceFile.getClassName());
    }

    private Class<?> loadClass(String className) {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

