/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.test.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.springframework.lang.Nullable;

class DynamicClassFileObject
extends SimpleJavaFileObject {
    private final String className;
    @Nullable
    private volatile byte[] bytes;

    DynamicClassFileObject(String className) {
        super(DynamicClassFileObject.createUri(className), JavaFileObject.Kind.CLASS);
        this.className = className;
    }

    DynamicClassFileObject(String className, byte[] bytes) {
        super(DynamicClassFileObject.createUri(className), JavaFileObject.Kind.CLASS);
        this.className = className;
        this.bytes = bytes;
    }

    private static URI createUri(String className) {
        return URI.create("class:///" + className.replace('.', '/') + ".class");
    }

    @Override
    public InputStream openInputStream() throws IOException {
        byte[] content = this.bytes;
        if (content == null) {
            throw new IOException("No data written");
        }
        return new ByteArrayInputStream(content);
    }

    @Override
    public OutputStream openOutputStream() {
        return new JavaClassOutputStream();
    }

    private void closeOutputStream(byte[] bytes) {
        this.bytes = bytes;
    }

    String getClassName() {
        return this.className;
    }

    @Nullable
    byte[] getBytes() {
        return this.bytes;
    }

    class JavaClassOutputStream
    extends ByteArrayOutputStream {
        JavaClassOutputStream() {
        }

        @Override
        public void close() {
            DynamicClassFileObject.this.closeOutputStream(this.toByteArray());
        }
    }
}

