/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.test.tools;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.core.test.tools.ClassFile;
import org.springframework.core.test.tools.ClassFiles;
import org.springframework.core.test.tools.CompileWithForkedClassLoaderClassLoader;
import org.springframework.core.test.tools.DynamicClassFileObject;
import org.springframework.core.test.tools.DynamicResourceFileObject;
import org.springframework.core.test.tools.ResourceFile;
import org.springframework.core.test.tools.ResourceFiles;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class DynamicClassLoader
extends ClassLoader {
    private final ClassFiles classFiles;
    private final ResourceFiles resourceFiles;
    private final Map<String, DynamicClassFileObject> dynamicClassFiles;
    private final Map<String, DynamicResourceFileObject> dynamicResourceFiles;
    @Nullable
    private final Method defineClassMethod;

    public DynamicClassLoader(ClassLoader parent, ClassFiles classFiles, ResourceFiles resourceFiles, Map<String, DynamicClassFileObject> dynamicClassFiles, Map<String, DynamicResourceFileObject> dynamicResourceFiles) {
        super(parent);
        this.classFiles = classFiles;
        this.resourceFiles = resourceFiles;
        this.dynamicClassFiles = dynamicClassFiles;
        this.dynamicResourceFiles = dynamicResourceFiles;
        Class<?> parentClass = parent.getClass();
        if (parentClass.getName().equals(CompileWithForkedClassLoaderClassLoader.class.getName())) {
            Method setClassResourceLookupMethod = DynamicClassLoader.lookupMethod(parentClass, "setClassResourceLookup", Function.class);
            ReflectionUtils.makeAccessible((Method)setClassResourceLookupMethod);
            ReflectionUtils.invokeMethod((Method)setClassResourceLookupMethod, (Object)this.getParent(), (Object[])new Object[]{this::findClassBytes});
            this.defineClassMethod = DynamicClassLoader.lookupMethod(parentClass, "defineDynamicClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            ReflectionUtils.makeAccessible((Method)this.defineClassMethod);
            this.dynamicClassFiles.forEach((name, file) -> this.defineClass((String)name, file.getBytes()));
        } else {
            this.defineClassMethod = null;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.defineClass(name, this.findClassBytes(name));
        return clazz != null ? clazz : super.findClass(name);
    }

    @Nullable
    private Class<?> defineClass(String name, @Nullable byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (this.defineClassMethod != null) {
            return (Class)ReflectionUtils.invokeMethod((Method)this.defineClassMethod, (Object)this.getParent(), (Object[])new Object[]{name, bytes, 0, bytes.length});
        }
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        URL resource = this.findResource(name);
        if (resource != null) {
            return new SingletonEnumeration<URL>(resource);
        }
        return super.findResources(name);
    }

    @Override
    @Nullable
    protected URL findResource(String name) {
        String className;
        byte[] classBytes;
        if (name.endsWith(".class") && (classBytes = this.findClassBytes(className = ClassUtils.convertResourcePathToClassName((String)name.substring(0, name.length() - ".class".length())))) != null) {
            return this.createResourceUrl(name, () -> classBytes);
        }
        DynamicResourceFileObject dynamicResourceFile = this.dynamicResourceFiles.get(name);
        if (dynamicResourceFile != null && dynamicResourceFile.getBytes() != null) {
            return this.createResourceUrl(dynamicResourceFile.getName(), dynamicResourceFile::getBytes);
        }
        ResourceFile resourceFile = this.resourceFiles.get(name);
        if (resourceFile != null) {
            return this.createResourceUrl(resourceFile.getPath(), resourceFile::getBytes);
        }
        return super.findResource(name);
    }

    @Nullable
    private byte[] findClassBytes(String name) {
        ClassFile classFile = this.classFiles.get(name);
        if (classFile != null) {
            return classFile.getContent();
        }
        DynamicClassFileObject dynamicClassFile = this.dynamicClassFiles.get(name);
        return dynamicClassFile != null ? dynamicClassFile.getBytes() : null;
    }

    private URL createResourceUrl(String name, Supplier<byte[]> bytesSupplier) {
        try {
            return new URL(null, "resource:///" + name, new ResourceFileHandler(bytesSupplier));
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static Method lookupMethod(Class<?> target, String name, Class<?> ... parameterTypes) {
        Method method = ReflectionUtils.findMethod(target, (String)name, (Class[])parameterTypes);
        Assert.notNull((Object)method, () -> "Could not find method '%s' on '%s'".formatted(name, target.getName()));
        return method;
    }

    private static class SingletonEnumeration<E>
    implements Enumeration<E> {
        @Nullable
        private E element;

        SingletonEnumeration(@Nullable E element) {
            this.element = element;
        }

        @Override
        public boolean hasMoreElements() {
            return this.element != null;
        }

        @Override
        @Nullable
        public E nextElement() {
            E next = this.element;
            this.element = null;
            return next;
        }
    }

    private static class ResourceFileHandler
    extends URLStreamHandler {
        private final Supplier<byte[]> bytesSupplier;

        ResourceFileHandler(Supplier<byte[]> bytesSupplier) {
            this.bytesSupplier = bytesSupplier;
        }

        @Override
        protected URLConnection openConnection(URL url) {
            return new ResourceFileConnection(url, this.bytesSupplier);
        }
    }

    private static class ResourceFileConnection
    extends URLConnection {
        private final Supplier<byte[]> bytesSupplier;

        protected ResourceFileConnection(URL url, Supplier<byte[]> bytesSupplier) {
            super(url);
            this.bytesSupplier = bytesSupplier;
        }

        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.bytesSupplier.get());
        }
    }
}

