/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.test.tools;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.springframework.core.test.tools.DynamicFile;
import org.springframework.lang.Nullable;

final class DynamicFiles<F extends DynamicFile>
implements Iterable<F> {
    private static final DynamicFiles<?> NONE = new DynamicFiles(Collections.emptyMap());
    private final Map<String, F> files;

    private DynamicFiles(Map<String, F> files) {
        this.files = files;
    }

    static <F extends DynamicFile> DynamicFiles<F> none() {
        return NONE;
    }

    DynamicFiles<F> and(Iterable<F> files) {
        LinkedHashMap merged = new LinkedHashMap(this.files);
        files.forEach(file -> merged.put(file.getPath(), file));
        return new DynamicFiles<F>(Collections.unmodifiableMap(merged));
    }

    DynamicFiles<F> and(F[] files) {
        LinkedHashMap merged = new LinkedHashMap(this.files);
        Arrays.stream(files).forEach(file -> merged.put(file.getPath(), file));
        return new DynamicFiles<F>(Collections.unmodifiableMap(merged));
    }

    DynamicFiles<F> and(DynamicFiles<F> files) {
        LinkedHashMap<String, F> merged = new LinkedHashMap<String, F>(this.files);
        merged.putAll(files.files);
        return new DynamicFiles<F>(Collections.unmodifiableMap(merged));
    }

    @Override
    public Iterator<F> iterator() {
        return this.files.values().iterator();
    }

    Stream<F> stream() {
        return this.files.values().stream();
    }

    boolean isEmpty() {
        return this.files.isEmpty();
    }

    @Nullable
    F get(String path) {
        return (F)((DynamicFile)this.files.get(path));
    }

    F getSingle() {
        return (F)this.getSingle(candidate -> true);
    }

    F getSingle(Predicate<F> filter) {
        List<F> files = this.files.values().stream().filter(filter).toList();
        if (files.size() != 1) {
            throw new IllegalStateException("No single file available");
        }
        return (F)((DynamicFile)files.iterator().next());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof DynamicFiles)) return false;
        DynamicFiles that = (DynamicFiles)other;
        if (!this.files.equals(that.files)) return false;
        return true;
    }

    public int hashCode() {
        return this.files.hashCode();
    }

    public String toString() {
        return this.files.toString();
    }
}

