/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.core.convert.support.GenericConversionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CollectionToArrayConverter
implements GenericConverter {
    private final GenericConversionService conversionService;

    public CollectionToArrayConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Class<?>[][] getConvertibleTypes() {
        return new Class[][]{{Collection.class, Object[].class}};
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return this.conversionService.convertNullSource(sourceType, targetType);
        }
        Collection sourceCollection = (Collection)source;
        TypeDescriptor sourceElementType = sourceType.getElementTypeDescriptor();
        if (sourceElementType == TypeDescriptor.NULL) {
            sourceElementType = ConversionUtils.getElementType(sourceCollection);
        }
        TypeDescriptor targetElementType = targetType.getElementTypeDescriptor();
        Object array = Array.newInstance(targetElementType.getType(), sourceCollection.size());
        int i = 0;
        if (sourceElementType == TypeDescriptor.NULL || sourceElementType.isAssignableTo(targetElementType)) {
            Iterator it = sourceCollection.iterator();
            while (it.hasNext()) {
                Array.set(array, i, it.next());
                ++i;
            }
        } else {
            GenericConverter converter = this.conversionService.getConverter(sourceElementType, targetElementType);
            if (converter == null) {
                throw new ConverterNotFoundException(sourceElementType, targetElementType);
            }
            for (Object sourceElement : sourceCollection) {
                Object targetElement = ConversionUtils.invokeConverter(converter, sourceElement, sourceElementType, targetElementType);
                Array.set(array, i, targetElement);
                ++i;
            }
        }
        return array;
    }
}

