/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.beans.PropertyEditorSupport;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.Assert;

public class ConvertingPropertyEditorAdapter
extends PropertyEditorSupport {
    private static final TypeDescriptor stringDescriptor = TypeDescriptor.valueOf(String.class);
    private final ConversionService conversionService;
    private final TypeDescriptor targetDescriptor;

    public ConvertingPropertyEditorAdapter(ConversionService conversionService, TypeDescriptor targetDescriptor) {
        Assert.notNull(conversionService, "ConversionService must not be null");
        Assert.notNull(targetDescriptor, "TypeDescriptor must not be null");
        this.conversionService = conversionService;
        this.targetDescriptor = targetDescriptor;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(this.conversionService.convert(text, stringDescriptor, this.targetDescriptor));
    }

    public String getAsText() {
        return (String)this.conversionService.convert(this.getValue(), this.targetDescriptor, stringDescriptor);
    }
}

