/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.MapEntryConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MapToObjectConverter
implements GenericConverter {
    private final GenericConversionService conversionService;

    public MapToObjectConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Class<?>[][] getConvertibleTypes() {
        return new Class[][]{{Map.class, Object.class}};
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return this.conversionService.convertNullSource(sourceType, targetType);
        }
        Map sourceMap = (Map)source;
        if (sourceMap.size() == 0) {
            if (targetType.typeEquals(String.class)) {
                return "";
            }
            return null;
        }
        if (targetType.typeEquals(String.class)) {
            TypeDescriptor sourceKeyType = sourceType.getMapKeyTypeDescriptor();
            TypeDescriptor sourceValueType = sourceType.getMapValueTypeDescriptor();
            if (sourceKeyType == TypeDescriptor.NULL || sourceValueType == TypeDescriptor.NULL) {
                TypeDescriptor[] sourceEntryTypes = ConversionUtils.getMapEntryTypes(sourceMap);
                sourceKeyType = sourceEntryTypes[0];
                sourceValueType = sourceEntryTypes[1];
            }
            boolean keysCompatible = false;
            if (sourceKeyType != TypeDescriptor.NULL && sourceKeyType.isAssignableTo(targetType)) {
                keysCompatible = true;
            }
            boolean valuesCompatible = false;
            if (sourceValueType != TypeDescriptor.NULL && sourceValueType.isAssignableTo(targetType)) {
                valuesCompatible = true;
            }
            Properties props = new Properties();
            if (keysCompatible && valuesCompatible) {
                Iterator iterator = sourceMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Map.Entry mapEntry = entry = iterator.next();
                    props.setProperty((String)mapEntry.getKey(), (String)mapEntry.getValue());
                }
                return this.store(props);
            }
            MapEntryConverter converter = new MapEntryConverter(sourceKeyType, sourceValueType, targetType, targetType, keysCompatible, valuesCompatible, this.conversionService);
            Iterator iterator = sourceMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry mapEntry = entry = iterator.next();
                Object key = converter.convertKey(mapEntry.getKey());
                Object value = converter.convertValue(mapEntry.getValue());
                props.setProperty((String)key, (String)value);
            }
            return this.store(props);
        }
        Object firstValue = sourceMap.values().iterator().next();
        TypeDescriptor sourceValueType = sourceType.getMapValueTypeDescriptor();
        if (sourceValueType == TypeDescriptor.NULL) {
            sourceValueType = TypeDescriptor.forObject(firstValue);
        }
        boolean valuesCompatible = false;
        if (sourceValueType != TypeDescriptor.NULL && sourceValueType.isAssignableTo(targetType)) {
            valuesCompatible = true;
        }
        if (valuesCompatible) {
            return firstValue;
        }
        MapEntryConverter converter = new MapEntryConverter(sourceValueType, sourceValueType, targetType, targetType, true, valuesCompatible, this.conversionService);
        return converter.convertValue(firstValue);
    }

    private String store(Properties props) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            props.store(os, null);
            return os.toString("ISO-8859-1");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to store [" + props + "] into String", e);
        }
    }
}

