/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectToObjectGenericConverter
implements ConditionalGenericConverter {
    ObjectToObjectGenericConverter() {
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Class<?> sourceClass = sourceType.getObjectType();
        Class<?> targetClass = targetType.getObjectType();
        return this.getValueOfMethodOn(targetClass, sourceClass) != null || this.getConstructor(targetClass, sourceClass) != null;
    }

    @Override
    public Class<?>[][] getConvertibleTypes() {
        return new Class[][]{{Object.class, Object.class}};
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        Object target;
        if (sourceType.isAssignableTo(targetType)) {
            return source;
        }
        Class<?> sourceClass = sourceType.getObjectType();
        Class<?> targetClass = targetType.getObjectType();
        Method method = this.getValueOfMethodOn(targetClass, sourceClass);
        if (method != null) {
            target = ReflectionUtils.invokeMethod(method, null, source);
        } else {
            Constructor<?> constructor = this.getConstructor(targetClass, sourceClass);
            if (constructor != null) {
                try {
                    target = constructor.newInstance(source);
                }
                catch (IllegalArgumentException e) {
                    throw new ConversionFailedException(sourceType, targetType, source, e);
                }
                catch (InstantiationException e) {
                    throw new ConversionFailedException(sourceType, targetType, source, e);
                }
                catch (IllegalAccessException e) {
                    throw new ConversionFailedException(sourceType, targetType, source, e);
                }
                catch (InvocationTargetException e) {
                    throw new ConversionFailedException(sourceType, targetType, source, e);
                }
            } else {
                throw new IllegalStateException("No static valueOf(" + sourceClass.getName() + ") method or Constructor(" + sourceClass.getName() + ") exists on " + targetClass.getName());
            }
        }
        return target;
    }

    private Method getValueOfMethodOn(Class<?> targetClass, Class<?> argType) {
        return ClassUtils.getStaticMethod(targetClass, "valueOf", argType);
    }

    private Constructor<?> getConstructor(Class<?> targetClass, Class<?> sourceClass) {
        return ClassUtils.getConstructorIfAvailable(targetClass, sourceClass);
    }
}

