/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTypeDescriptor
extends TypeDescriptor {
    private final PropertyDescriptor propertyDescriptor;

    public PropertyTypeDescriptor(MethodParameter methodParameter, PropertyDescriptor propertyDescriptor) {
        super(methodParameter);
        this.propertyDescriptor = propertyDescriptor;
    }

    public static PropertyTypeDescriptor forNestedType(MethodParameter methodParameter, PropertyDescriptor propertyDescriptor) {
        return PropertyTypeDescriptor.forNestedType(PropertyTypeDescriptor.resolveNestedType(methodParameter), methodParameter, propertyDescriptor);
    }

    public static PropertyTypeDescriptor forNestedType(Class<?> nestedType, MethodParameter methodParameter, PropertyDescriptor propertyDescriptor) {
        return new PropertyTypeDescriptor(nestedType, methodParameter, propertyDescriptor);
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    @Override
    protected Annotation[] resolveAnnotations() {
        Annotation ann;
        int n;
        int n2;
        Annotation[] annotationArray;
        LinkedHashMap<Class<? extends Annotation>, Annotation> annMap = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
        String name = this.propertyDescriptor.getName();
        if (StringUtils.hasLength(name)) {
            Class<?> clazz = this.getMethodParameter().getMethod().getDeclaringClass();
            Field field = ReflectionUtils.findField(clazz, name);
            if (field == null && (field = ReflectionUtils.findField(clazz, String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1))) == null) {
                field = ReflectionUtils.findField(clazz, String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1));
            }
            if (field != null) {
                annotationArray = field.getAnnotations();
                n2 = annotationArray.length;
                n = 0;
                while (n < n2) {
                    ann = annotationArray[n];
                    annMap.put(ann.annotationType(), ann);
                    ++n;
                }
            }
        }
        Method writeMethod = this.propertyDescriptor.getWriteMethod();
        Method readMethod = this.propertyDescriptor.getReadMethod();
        if (writeMethod != null && writeMethod != this.getMethodParameter().getMethod()) {
            annotationArray = writeMethod.getAnnotations();
            n2 = annotationArray.length;
            n = 0;
            while (n < n2) {
                ann = annotationArray[n];
                annMap.put(ann.annotationType(), ann);
                ++n;
            }
        }
        if (readMethod != null && readMethod != this.getMethodParameter().getMethod()) {
            annotationArray = readMethod.getAnnotations();
            n2 = annotationArray.length;
            n = 0;
            while (n < n2) {
                ann = annotationArray[n];
                annMap.put(ann.annotationType(), ann);
                ++n;
            }
        }
        annotationArray = this.getMethodParameter().getMethodAnnotations();
        n2 = annotationArray.length;
        n = 0;
        while (n < n2) {
            ann = annotationArray[n];
            annMap.put(ann.annotationType(), ann);
            ++n;
        }
        annotationArray = this.getMethodParameter().getParameterAnnotations();
        n2 = annotationArray.length;
        n = 0;
        while (n < n2) {
            ann = annotationArray[n];
            annMap.put(ann.annotationType(), ann);
            ++n;
        }
        return annMap.values().toArray(new Annotation[annMap.size()]);
    }

    @Override
    protected TypeDescriptor newNestedTypeDescriptor(Class<?> nestedType, MethodParameter nested) {
        return new PropertyTypeDescriptor(nestedType, nested, this.propertyDescriptor);
    }

    private PropertyTypeDescriptor(Class<?> nestedType, MethodParameter methodParameter, PropertyDescriptor propertyDescriptor) {
        super(nestedType, methodParameter);
        this.propertyDescriptor = propertyDescriptor;
    }
}

